(function($) {

    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt Informationen zu Ihrer WAN(Internet)-Verbindung an."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die Hardwareadresse des Internet(WAN)-Ports Ihres Routers."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Die dem Internet(WAN)-Port Ihres Routers zugewiesene IP-Adresse. Wird hier 0.0.0.0 angezeigt, haben Sie keinen Internetzugriff."
                }, {
                    type: "name",
                    title: "Subnetzmaske",
                    content: "Zeigt an, welcher Teil Ihrer IP-Adresse das Netz und welcher den Host identifiziert. Standardwert: 255.255.255.0."
                }, {
                    type: "name",
                    title: "Standard-Gateway",
                    content: "Die IP-Adresse, über die Ihr Router den Weg ins Internet findet."
                }, {
                    type: "name",
                    title: "Haupt-DNS-Server/Backup-DNS-Server",
                    content: "Der Domänennamenservice (DNS) wandelt Hostnamen/Domänennamen in IP-Adressen um. Deren Adressen bekommt Ihr Router automatisch von Ihrem Internetdiensteanbieter mitgeteilt."
                }, {
                    type: "name",
                    title: "Verbindungstyp",
                    content: "Der Verbindungstyp des Internet(WAN)-Ports."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die Hardwareadresse des Internet(WAN)-Ports Ihres Routers."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Die dem Internet(WAN)-Port Ihres Routers zugewiesene IP-Adresse."
                }, {
                    type: "name",
                    title: "Standard-Gateway",
                    content: "Die IP-Adresse, über die Ihr Router den Weg ins Internet findet."
                }, {
                    type: "name",
                    title: "Haupt-DNS-Server/Backup-DNS-Server",
                    content: "Der Domänennamenservice (DNS) wandelt Hostnamen/Domänennamen in IP-Adressen um. Deren Adressen bekommt Ihr Router automatisch von Ihrem Internetdiensteanbieter mitgeteilt."
                }, {
                    type: "name",
                    title: "Verbindungstyp",
                    content: "Der Verbindungstyp des Internet(WAN)-Ports."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "Powerlinenetz",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Klicken Sie auf das Powerlinenetzsymbol, um eine Liste aller Powerlinegeräte in Ihrem Powerlinenetz anzuzeigen."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Klicken Sie auf das Powerlinesymbol, um detaillierte Informationen zu Ihrem Powerlineadapter anzuzeigen."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die ID des Powerlineadapters."
                }, {
                    type: "name",
                    title: "Powerlineschlüssel",
                    content: "Der Geräteschlüssel dieses Powerlinegeräts. Mit diesem können Sie dieses Ihrem Powerlinenetz hinzufügen. Sie finden den Schlüssel auf dem Produktetikett."
                }, {
                    type: "name",
                    title: "Netzname",
                    content: "Der Name des Netzes, in dem der Powerlineadapter sich befindet. Standardwert: HomePlugAV."
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "2,4GHz<span class=\"anti_5g\">/5GHz</span>-WLAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Status und Grundinformationen zu Ihrem WLAN."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Der aktuelle Status (ein/aus) Ihres WLANs."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Service Set Identifier, auch als WLAN-Name bekannt."
                }, {
                    type: "name",
                    title: "Kanal",
                    content: "Der aktuell verwendete WLAN-Kanal."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die WLAN-MAC-Adresse des Powerline-Adapters."
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt Informationen zu Ihrer LAN-Verbindung an."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die Hardwareadresse der LAN-Ports Ihres Routers."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Die LAN-IPv4-Adresse des Routers."
                }, {
                    type: "name",
                    title: "Subnetzmaske",
                    content: "Zeigt an, welcher Teil Ihrer IP-Adresse das Netz und welcher den Host identifiziert. Standardwert: 255.255.255.0."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "Zeigt an, ob der DHCP-Server des Routers aktiv ist."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die Hardwareadresse der LAN-Ports Ihres Routers."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Die dem Internet(WAN)-Port Ihres Routers zugewiesene IPv6-Adresse."
                }, {
                    type: "name",
                    title: "Link-lokale Adresse",
                    content: "IPv6-Link-Adresse des LAN-Ports."
                }, {
                    type: "name",
                    title: "Zugewiesener Typ",
                    content: "Der IPv6-Adresstyp der LAN-Schnittstelle."
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "2,4GHz<span class=\"anti_5g\">/5GHz</span>-Gast-WLAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt Informationen zum Gast-WLAN an."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Der aktuelle Status (ein/aus) Ihres Gastnetzes."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Der Name Ihres Gast-WLANs."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "USB-Geräte",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt Informationen zu den aktuell angeschlossenen USB-Geräten (Speichermedien oder Drucker) an."
                }, {
                    type: "name",
                    title: "Drucker",
                    content: "Name des angeschlossenen Druckers."
                }, {
                    type: "name",
                    title: "Gesamt",
                    content: "Die Gesamtkapazität des angeschlossenen USB-Datenträgers."
                }, {
                    type: "name",
                    title: "Verfügbar",
                    content: "Der freie Speicherplatz auf dem angeschlossenen USB-Datenträger."
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "Performance",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt Informationen zur aktuellen Routerperformance."
                }, {
                    type: "name",
                    title: "CPU-Last",
                    content: "Die aktuelle Prozessorauslastung."
                }, {
                    type: "name",
                    title: "Speichernutzung",
                    content: "Aktuelle Arbeitsspeicherbelegung."
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "Kabelgebundene Teilnehmer",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt Informationen zu den angeschlossenen Ethernetgeräten an."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "WLAN-Teilnehmer",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Klicken Sie auf das WLAN-Teilnehmer-Symbol, um Informationen zu allen aktuell verbundenen WLAN-Geräten anzuzeigen."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die MAC-Adresse des WLAN-Gerätes."
                }, {
                    type: "name",
                    title: "WLAN-Band",
                    content: "Das WLAN-Band <span class=\"anti_5g\">(2,4GHz oder 5GHz)</span>, mit dem der Client verbunden ist."
                }
            ]
        },
        STATUS_WIFI_MOVE: {
            TITLE: "WiFi-Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt an, ob WiFi-Move aktiv ist."
                }
            ]
        },
        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "Internetverbindungstyp: Statische IP-Adresse"
                }, {
                    type: "paragraph",
                    content: "Wählen Sie dies aus, wenn Ihr Internetdiensteanbieter Ihnen eine statische IP-Konfiguration bereitgestellt hat (bestehend aus IP-Adresse, Subnetzmaske, Gateway- und DNS-Serveradresse(n))."
                }, {
                    type: "name",
                    title: "IP-Adresse, Subnetzmaske, Standardgateway, Haupt-/Backup-DNS-Server",
                    content: "Geben Sie hier die von Ihrem Internetdiensteanbieter vorgegebenen Werte ein."
                }, {
                    type: "name",
                    title: "MTU-Größe",
                    content: "Ein typischer Wert für die MTU(Maximum Transmission Unit)-Größe von Ethernet-Anwendungen ist 1500 Byte. Wir empfehlen, diese nicht zu ändern, es sei denn, Sie wurden angewiesen, dies zu tun."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: Dynamische IP-Adresse"
                }, {
                    type: "paragraph",
                    content: "Wählen Sie diesen Typ aus, wenn Ihr Internetdiensteanbieter einen DHCP-Dienst anbietet."
                }, {
                    type: "name",
                    title: "IP-Adresse, Subnetzmaske, Standardgateway, Haupt-/Backup-DNS-Server",
                    content: "Diese Informationen werden vom DHCP-Server Ihres Internetdiensteanbieters automatisch gesetzt."
                }, {
                    type: "name",
                    title: "Erneuern",
                    content: "Klicken Sie hier, um Ihre IP-Konfiguration zu erneuern."
                }, {
                    type: "name",
                    title: "Freigeben",
                    content: "Klicken Sie hier, um Ihre aktuelle IP-Konfiguration zurückzugeben."
                }, {
                    type: "name",
                    title: "Folgende DNS-Serveradressen benutzen",
                    content: "Hat Ihr Internetdiensteanbieter Ihnen eine oder zwei DNS-Serveradressen gegeben, wählen Sie dies an und geben Sie die Haupt- und die Backup-DNS-Serveradresse in die Felder ein. Ansonsten werden die DNS-Serveradressen dynamisch von Ihrem Internetdiensteanbieter zugewiesen."
                }, {
                    type: "name",
                    title: "MTU-Größe",
                    content: "Ein typischer Wert für die MTU(Maximum Transmission Unit)-Größe von Ethernet-Anwendungen ist 1500 Byte. Wir empfehlen, diese nicht zu ändern, es sei denn, Sie wurden angewiesen, dies zu tun."
                }, {
                    type: "name",
                    title: "Hostname",
                    content: "Der Wert, den Sie hier eingeben, spezifiziert den Hostnamen Ihres Routers."
                }, {
                    type: "name",
                    title: "IP-Konfiguration mittels Unicast abfragen",
                    content: "Aktivieren Sie dies, wenn der DHCP-Server Ihres Internetdiensteanbieters keine Broadcastanwendungen unterstützt und Sie auf diesem Wege keine IP-Adresse abrufen können."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Bekommen Sie Fehler wie “Adresse nicht gefunden”, nachdem Sie die DNS-Serveradressen eingegeben haben, ist wahrscheinlich Ihre DNS-Serverkonfiguration falsch. Bitte wenden Sie sich an Ihren Internetdiensteanbieter, um Hilfe zu erhalten."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: PPPoE"
                }, {
                    type: "paragraph",
                    content: "Wählen Sie diesen Typ aus, wenn Sie DSL haben und hierfür einen Benutzernamen und ein Passwort von Ihrem Internetdiensteanbieter bekommen haben."
                }, {
                    type: "name",
                    title: "Benutzername/Passwort",
                    content: "Geben Sie hier die von Ihrem Internetdiensteanbieter vorgegebenen Zugangsdaten ein. Achten Sie hier auf Groß- und Kleinschreibung."
                }, {
                    type: "name",
                    title: "Internet IP-Adresse/Haupt-DNS-Server/Backup-DNS-Server",
                    content: "Diese Parameter werden bei der Einwahl automatisch eingestellt."
                }, {
                    type: "name",
                    title: "Zweitverbindung (Keine, Dynamische IP-Adresse, Statische IP-Adresse)",
                    children: [
                        {
                            type: "name",
                            title: "Nicht vorhanden",
                            content: "Wählen Sie dies aus, wenn Sie keine Zweitverbindung verwenden."
                        }, {
                            type: "name",
                            title: "Dynamische IP-Adresse",
                            content: "Wählen Sie dies aus, wenn IP-Adresse und Subnetzmaske von Ihrem Internetdiensteanbieter automatisch vergeben werden.",
                            children: [
                                {
                                    type: "name",
                                    title: "Erneuern",
                                    content: "Klicken Sie hier, um Ihre IP-Konfiguration zu erneuern."
                                }, {
                                    type: "name",
                                    title: "Freigeben",
                                    content: "Klicken Sie hier, um Ihre aktuelle IP-Konfiguration zurückzugeben."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Statische IP-Adresse",
                            content: "Wählen Sie dies, wenn Sie IP-Adresse, Subnetzmaske, Standardgateway und DNS-Serveradressen von Ihrem Internetdiensteanbieter bekommen haben und geben Sie diese in die passenden Felder ein."
                        }
                    ]
                }, {
                    type: "name",
                    title: "MTU-Größe",
                    content: "Ein typischer Wert für die MTU(Maximum Transmission Unit)-Größe von Ethernet-Anwendungen ist 1480 Byte.",
                    children: [
                        {
                            type: "note",
                            title: "Hinweis",
                            content: "Hinweis: In seltenen Fällen muss dieser Wert angepasst werden. Wir empfehlen, dies nicht zu tun, solange Ihr Internetdiensteanbieter dies Ihnen nicht vorschreibt."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Dienstname/AC-Name",
                    content: "Diese Felder können frei bleiben, wenn Ihr Internetdiensteanbieter Ihnen nichts Anderslautendes sagt."
                }, {
                    type: "name",
                    title: "Intervall für Online-Erkennung",
                    content: "Geben Sie ein Zeitintervall von 0 bis 120 (in Sekunden) ein, in dem der Router den Status des Access-Concentrators abruft. Standardwert: 0, bedeutet keine Erkennung."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Hat Ihnen Ihr Internetdiensteanbieter eine bestimmte (feste) IP-Adresse mitgeteilt, wählen Sie Folgende IP-Adresse verwenden aus und geben Sie sie in das Feld ein. Ansonsten wählen Sie Dynamisch vom Internetdiensteanbieter aus, um eine IP-Adresse vom Server automatisch abzurufen."
                }, {
                    type: "name",
                    title: "DNS-Serveradresse/Haupt-/Backup-DNS-Server",
                    content: "Bekommen Sie von Ihrem Internetdiensteanbieter eine feste DNS-Serveradresse zugewiesen, wählen Sie Folgende DNS-Serveradresse(n) verwenden und geben Sie sie hier ein. Ansonsten wählen Sie DNS-Serveradresse dynamisch abfragen."
                }, {
                    type: "name",
                    title: "Verbindungsmodus",
                    content: "Wählen Sie hier den von Ihnen gewünschten Internetverbindungsmodus aus.",
                    children: [
                        {
                            type: "name",
                            title: "Automatisch",
                            content: "Automatische Wiederverbindung, wenn die Internetverbindung getrennt wird."
                        }, {
                            type: "name",
                            title: "Bei Bedarf",
                            content: "Werden für eine gewisse Zeit (Maximale Leerlaufzeit) keine Internetdaten über Ihren Router übertragen, wird die Verbindung getrennt. Bei einer erneuten Verbindungsanfrage wird sie automatisch wiederhergestellt."
                        }, {
                            type: "name",
                            title: "Zeitbasierend",
                            content: "In dieser Betriebsart wird die Internetverbindung nur für den angegebenen Zeitraum hergestellt. Ist diese Option gewählt, geben Sie Startzeit und Endzeit ein. Beide sind im Format HH:MM einzugeben."
                        }, {
                            type: "name",
                            title: "Manuell",
                            content: "Zum Herstellen und Trennen Ihrer Internetverbindung bedarf es eines Klicks in der Weboberfläche. Definieren Sie eine Maximale Leerlaufzeit, wird die Verbindung auch getrennt, wenn über dieses Zeitintervall keine Internetdaten durch Ihren Router gegangen sind. Standardwert hierfür: 15 Minuten. Deaktivieren Sie die Maximale Leerlaufzeit, indem Sie den Wert 0 setzen."
                        }, {
                            type: "note",
                            title: "Hinweis",
                            content: "Die Zeitbasierende Verbindung funktoniert nur, wenn unter Erweitert → Systemtools → Uhrzeiteinstellungen die Systemzeit  konfiguriert wurde."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: BigPond-Cable"
                }, {
                    type: "paragraph",
                    content: "Verwenden Sie diese Option für Bigpond-Cable-Anbieter."
                }, {
                    type: "name",
                    title: "Benutzername/Passwort",
                    content: "Geben Sie hier die von Ihrem Internetdiensteanbieter vorgegebenen Zugangsdaten ein. Achten Sie hier auf Groß- und Kleinschreibung."
                }, {
                    type: "name",
                    title: "Authentifizierungsserver",
                    content: "Geben Sie die IP-Adresse oder den Hostnamen des Authentifizierungsservers ein."
                }, {
                    type: "name",
                    title: "Authentifizierungsdomäne",
                    content: "Das Domänennamensuffix Ihres Standortes. Beispiel: nsw.bigpond.net.au für NSW/ACT, vic.bigpond.net.au für VIC/TAS/WA/SA/NT und qld.bigpond.net.au für QLD."
                }, {
                    type: "name",
                    title: "MTU-Größe",
                    content: "Die Standard- und typische MTU(Maximum Transmission Unit)-Größe für die meisten Ethernet-Netze beträgt 1500 Byte. Es wird nicht empfohlen, diese zu ändern, außer Ihr Internetdiensteanbieter weist Sie an, dies zu tun."
                }, {
                    type: "name",
                    title: "Verbindungsmodus",
                    content: "Wählen Sie hier den von Ihnen gewünschten Internetverbindungsmodus aus.",
                    children: [
                        {
                            type: "name",
                            title: "Automatisch",
                            content: "Automatische Wiederverbindung, wenn die Internetverbindung getrennt wird."
                        }, {
                            type: "name",
                            title: "Bei Bedarf",
                            content: "Werden für eine gewisse Zeit (Maximale Leerlaufzeit) keine Internetdaten über Ihren Router übertragen, wird die Verbindung getrennt. Bei einer erneuten Verbindungsanfrage wird sie automatisch wiederhergestellt."
                        }, {
                            type: "name",
                            title: "Manuell",
                            content: "Zum Herstellen und Trennen Ihrer Internetverbindung bedarf es eines Klicks in der Weboberfläche. Definieren Sie eine Maximale Leerlaufzeit, wird die Verbindung auch getrennt, wenn über dieses Zeitintervall keine Internetdaten durch Ihren Router gegangen sind. Standardwert hierfür: 15 Minuten. Deaktivieren Sie die Maximale Leerlaufzeit, indem Sie den Wert 0 setzen."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: L2TP/PPTP"
                }, {
                    type: "paragraph",
                    content: "Wählen Sie diesen Typ, wenn Sie sich mit einem L2TP-/PPTP-VPN-Server verbinden möchten und mit Benutzernamen, Passwort und IP-Adresse/Domänennamen ausgestattet sind."
                }, {
                    type: "name",
                    title: "Benutzername/Passwort",
                    content: "Geben Sie hier die von Ihrem Internetdiensteanbieter vorgegebenen Zugangsdaten ein. Achten Sie hier auf Groß- und Kleinschreibung."
                }, {
                    type: "name",
                    title: "Internet IP-Adresse/Haupt-DNS-Server/Backup-DNS-Server",
                    content: "Diese Parameter werden automatisch von Ihrem Internetdiensteanbieter zugewiesen."
                }, {
                    type: "name",
                    title: "Zweitverbindung (Dynamische oder Statische IP-Adresse)",
                    children: [
                        {
                            type: "name",
                            title: "Dynamische IP-Adresse",
                            content: "Wählen Sie dies aus, wenn IP-Adresse und Subnetzmaske von Ihrem Internetdiensteanbieter automatisch vergeben werden.",
                            children: [
                                {
                                    type: "name",
                                    title: "Erneuern",
                                    content: "Klicken Sie hier, um Ihre IP-Konfiguration zu erneuern."
                                }, {
                                    type: "name",
                                    title: "Freigeben",
                                    content: "Klicken Sie hier, um Ihre aktuelle IP-Konfiguration zurückzugeben."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Statische IP-Adresse",
                            content: "Wählen Sie dies, wenn Sie IP-Adresse, Subnetzmaske, Standardgateway und DNS-Serveradressen von Ihrem Internetdiensteanbieter bekommen haben und geben Sie diese in die passenden Felder ein."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP-Adresse/Domänenname des VPN-Servers",
                    content: "Geben Sie die IP-Adresse oder den Hostnamen des VPN-Servers ein."
                }, {
                    type: "name",
                    title: "MTU-Größe",
                    content: "Die Standard- und typische MTU(Maximum Transmission Unit)-Größe für die meisten Ethernet-Netze beträgt 1460 Byte. Es wird nicht empfohlen, diese zu ändern, außer Ihr Internetdiensteanbieter weist Sie an, dies zu tun."
                }, {
                    type: "name",
                    title: "Verbindungsmodus",
                    content: "Wählen Sie hier den von Ihnen gewünschten Internetverbindungsmodus aus.",
                    children: [
                        {
                            type: "name",
                            title: "Automatisch",
                            content: "Automatische Wiederverbindung, wenn die Internetverbindung getrennt wird."
                        }, {
                            type: "name",
                            title: "Bei Bedarf",
                            content: "Werden für eine gewisse Zeit (Maximale Leerlaufzeit) keine Internetdaten über Ihren Router übertragen, wird die Verbindung getrennt. Bei einer erneuten Verbindungsanfrage wird sie automatisch wiederhergestellt."
                        }, {
                            type: "name",
                            title: "Manuell",
                            content: "Zum Herstellen und Trennen Ihrer Internetverbindung bedarf es eines Klicks in der Weboberfläche. Definieren Sie eine Maximale Leerlaufzeit, wird die Verbindung auch getrennt, wenn über dieses Zeitintervall keine Internetdaten durch Ihren Router gegangen sind. Standardwert hierfür: 15 Minuten. Deaktivieren Sie die Maximale Leerlaufzeit, indem Sie den Wert 0 setzen."
                        }
                    ]
                }
            ]
        },
        HELP_PLC_STATION: {
            TITLE: "Liste der Powerlinegeräte",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt Informationen zu  sämtlichen Powerlinegeräten in Ihrem Netz."
                }, {
                    type: "name",
                    title: "Lokales Gerät",
                    content: "Der Powerlineadapter, in den sie aktuell eingeloggt sind."
                }, {
                    type: "step",
                    content: ["In der Liste der Powerlinegeräte werden MAC-Adresse und Datentransferrate des Geräts von links nach rechts angezeigt.", "Klicken Sie auf das <b>Mülltonnensymbol</b>, um das Powerlinegerät aus Ihrem Netz zu entfernen.", "Klicken Sie auf das <b>Plus-Symbol</b>, um Ihrem Powerlinenetz einen neuen Powerlineadapter mittels Gerätepasswort hinzuzufügen."]
                }, {
                    type: "name",
                    title: "Zurück",
                    content: "Klicken Sie, um zurück auf die Statusseite zu gelangen."
                }, {
                    type: "name",
                    title: "Neu laden",
                    content: "Klicken Sie, um die Seite zu aktualisieren."
                }
            ]
        },
        INTERNET_MAC: {
            TITLE: "MAC-Adresse klonen",
            CONTENT: [
                {
                    type: "name",
                    title: "Standard-MAC-Adresse benutzen",
                    content: "Standard-MAC-Adresse des Routers wiederherstellen."
                }, {
                    type: "name",
                    title: "MAC-Adresse des Computers verwenden",
                    content: "Hiermit kopieren Sie die MAC-Adresse Ihres Computers. Sinnvoll, wenn Ihr Computer bisher direkt an das Internet angeschlossen war (ohne Router) und Ihr Internetdiensteanbieter sich diese MAC-Adresse gemerkt hat."
                }, {
                    type: "name",
                    title: "Benutzerdefinierte MAC-Adresse",
                    content: "Geben Sie die gewünschte MAC-Adresse von Hand ein."
                }
            ]
        },
        LAN_IPV4: {
            TITLE: "LAN-Einstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "LAN-Typ",
                    content: "Wählen Sie Dynamische IP-Adresse oder Statische IP-Adresse."
                }, {
                    type: "name",
                    title: "Dynamische IP-Adresse",
                    content: "Wählen Sie diese Option, um automatisch eine IP-Adresse vom DHCP-Server anbzurufen."
                }, {
                    type: "name",
                    title: "Statische IP-Adresse",
                    content: "Wählen Sie diese Option, um IP-Adresse, Subnetzmaske und Standardgateway von Hand anzugeben."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Zeigt die Standard-IP-Adresse des Powerlineadapters an. Mit dieser kommen Sie auf die Weboberfläche, and can be overridden."
                }, {
                    type: "name",
                    title: "Subnetzmaske",
                    content: "Wählen Sie aus der Drop-Down-Liste eine Subnetzmaske aus oder geben Sie eine neue ein."
                }, {
                    type: "name",
                    title: "Standard-Gateway",
                    content: "Die IP-Adresse, die der Adapter in Ihrem Netz hat."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Speichern</b>, um all Ihre Einstellungen zu speichern."
                }
            ]
        },
        LED_TIME: {
            TITLE: "LED-Zeitplan",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Die LED-Planung ermöglicht es Ihnen, die LEDs dieses Powerlineadapters zu den vorgegebenen Zeitpunkten ein-/auszuschalten."
                }, {
                    type: "name",
                    title: "LED-Planer",
                    content: "Aktivieren Sie dies,  um die LED-Planung zu benutzen."
                }
            ]
        },
        LED_TIME_GRID: {
            TITLE: "Zeitraum, in dem die LEDs ausgeschaltet sind",
            CONTENT: [
                {
                    type: "name",
                    title: "Von",
                    content: "Zeigt die Uhrzeit an, zu der die LEDs abgeschaltet werden."
                }, {
                    type: "name",
                    title: "An",
                    content: "Zeigt die Uhrzeit an, zu der die LEDs eingeschaltet werden."
                }, {
                    type: "name",
                    title: "Wochentag(e)",
                    content: "Die Wochentage, für die dieser Zeitplan gelten soll."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Aktueller Status des Zeitplans. Klicken Sie auf die <b>Birne</b>, um den Plan zu (de)aktivieren."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Zeigt Optionen zum <b>Bearbeiten</b> oder <b>Löschen</b> des Plans."
                }, {
                    type: "step",
                    title: "Erstellen eines neuen Plans",
                    content: ["1. Klicken Sie <b>Hinzufügen</b>.", "2. Geben Sie einen Zeitraum an, in dem die LEDs aus sein sollen.", "3. Wählen Sie die Wochentage, für dieser Plan gelten soll.", "4. Wählen Sie <b>Eintrag aktivieren</b>.", "5. Klicken Sie <b>OK</b>, um die Einstellungen zu speichern."]
                }, {
                    type: "paragraph",
                    content: "Um einen Plan zu bearbeiten oder zu löschen, klicken Sie <b>Bearbeiten</b>, um die Informationen zu bearbeiten oder die <b>Mülltonne</b>, um den Plan zu löschen."
                }, {
                    type: "paragraph",
                    content: "Um mehrere Zeitpläne zu löschen, haken Sie diese an und klicken Sie dann über der Tabelle <b>Löschen</b>."
                }
            ]
        },
        HELP_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die Ihrem Powerlinegerät zugewiesene physische Adresse."
                }, {
                    type: "name",
                    title: "Powerlineschlüssel",
                    content: "Der Geräteschlüssel dieses Powerlinegeräts. Mit diesem können Sie dieses Ihrem Powerlinenetz hinzufügen. Sie finden den Schlüssel auf dem Produktetikett."
                }, {
                    type: "name",
                    title: "Netzname",
                    content: "Der Name des Powerlinenetzes, dem der Powerlineadapter zugewiesen ist. Sie können den Namen hier ändern oder den Standardnamen (HomePlugAV) zuweisen, indem Sie Standard klicken. Ändern Sie den Namen, wird WiFi-Move automatisch deaktiviert."
                }
            ]
        },
        IPTV: {
            TITLE: "Einstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "IPTV",
                    content: "IPTV aktivieren."
                }, {
                    type: "name",
                    title: "Modus",
                    content: "Wählen Sie einen der sechs folgenden Modi gemäß den Vorgaben Ihres Anbieters aus:",
                    children: [
                        {
                            type: "name",
                            title: "Bridge",
                            content: "Ist Ihr Internetdiensteanbieter nicht aufgeführt und sind keine anderen Parameters erforderlich, wählen Sie einfach diesen Modus aus und konfigurieren Sie den LAN-Port Ihres Routers.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Wählen Sie aus, ob dieser LAN-Port für Internet oder für IPTV genutzt wird."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Russland",
                            content: "Wählen Sie dies für einen russischen Anbieter mit vordefinierten Parametern: Internet/IP-Phone/IPTV-VLAN-IDs und Priorität. Konfigurieren Sie dann die LAN-Ports 1 bis 4.",
                            children: [
                                {
                                    type: "name",
                                    title: "IPTV-Multicast-VLAN-ID/-Priorität",
                                    content: "Aktivieren Sie IPTV-Multicast und setzen Sie VLAN-ID und Priorität gemäß den Vorgaben Ihres Internetdiensteanbieters."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Singapore-ExStream",
                            content: "Wählen Sie dies für den singapurischen Internetdiensteanbieter ExStream mit vorgegebenen Parametern: Internet/IPTV-VLAN-IDs und -Priorität sowie LAN(1/2/3/4)-Portkonfiguration."
                        }, {
                            type: "name",
                            title: "Malaysia-Unifi",
                            content: "Wählen Sie dies für den malaysischen Anbieter Unifi mit vordefinierten Parametern: Internet/IP-Phone/IPTV-VLAN-IDs und Priorität. Konfigurieren Sie dann die LAN-Ports 1 bis 4."
                        }, {
                            type: "name",
                            title: "Malaysia-Maxis",
                            content: "Wählen Sie dies für den malaysischen Anbieter Maxis mit vordefinierten Parametern: Internet/IP-Phone/IPTV-VLAN-IDs und Priorität. Konfigurieren Sie dann die LAN-Ports 1 bis 4."
                        }, {
                            type: "name",
                            title: "Benutzerdefiniert",
                            content: "Wählen Sie dies, wenn Ihr Internetdiensteanbieter nicht in der Liste aufgeführt ist und Ihnen die erforderlichen Parameter vorliegen: Internet/IP-Phone/IPTV-VLAN-IDs und Priorität. Konfigurieren Sie dann die LAN-Ports 1 bis 4.",
                            children: [
                                {
                                    type: "name",
                                    title: "Internet/IP-Telefon/IPTV-VLAN-ID/Priorität",
                                    content: "Konfigurieren Sie die VLAN-IDs, wie von Ihrem Internetdiensteanbieter vorgegeben."
                                }, {
                                    type: "name",
                                    title: "802.11Q-Tag",
                                    content: "Bitte auswählen, wenn die Internetpakete gemäß 802.11Q getaggt werden sollen."
                                }, {
                                    type: "name",
                                    title: "IPTV-Multicast-VLAN-ID/Priorität",
                                    content: "Aktivieren Sie IPTV-Multicast und setzen Sie VLAN-ID und Priorität gemäß den Vorgaben Ihres Internetdiensteanbieters."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Wählen Sie aus, ob ein LAN-Port für Internet oder für IPTV verwendet werden soll."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "IGMP-Proxy",
                    content: "Wählen Sie die IGMP(Internet Group Management Protocol)-Proxy-Version aus (entweder V2 oder V3, Vorgabe Ihres Internetdiensteanbieters)."
                }
            ]
        },
        DHCP_SERVER_SETTINGS: {
            TITLE: "Einstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "DHCP-Server",
                    content: "Standardmäßig ist der DHCP(Dynamic Host Configuration Protocol)-Server aktiv. Dieser weist Clientgeräten TCP/IP-Parameter aus dem Adresspool dynamisch zu. Deaktivieren Sie den DHCP-Server nicht, wenn Sie keinen anderen aktiven DHCP-Server im Netz haben und Sie Ihre IP-Konfigurationen nicht alle von Hand vornehmen möchten."
                }, {
                    type: "name",
                    title: "IP-Adresspool",
                    content: "Geben Sie den IP-Adressbereich an, der für DHCP-Clients reserviert werden soll."
                }, {
                    type: "name",
                    title: "Adresshaltezeit",
                    content: "Geben Sie die Dauer an, für die ein Client seine IP-Konfiguration behalten kann (2 bis 2880 Minuten, Standardwert: 120 Minuten)."
                }, {
                    type: "name",
                    title: "Standard-Gateway",
                    content: "Geben Sie hier die LAN-IP-Adresse ein (optional)."
                }, {
                    type: "name",
                    title: "Haupt-DNS-Server/Backup-DNS-Server",
                    content: "(optional) Hier können Sie DNS-Serveradressen eingeben."
                }
            ]
        },
        RESERVED_IP_ADDRESS: {
            TITLE: "Adressreservierung",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Sie können IP-Adressen von mit dem Router verbundenen Geräten reservieren. Eine reservierte IP-Adresse wird nur dem Gerät zugewiesen, dem sie zugeordnet ist."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "MAC-Adresse des Gerätes, für das eine IP-Adresse reserviert ist."
                }, {
                    type: "name",
                    title: "Reservierte IP-Adresse",
                    content: "Die IP-Adresse, die für dieses Gerät reserviert ist."
                }, {
                    type: "name",
                    title: "Beschreibung",
                    content: "Eine frei wählbare Beschreibung für das Gerät (z.B. Blu-ray-Player)."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Aktueller Status des Gerätes (aktiviert oder deaktiviert)."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Optionen zum Löschen oder Bearbeiten eines Eintrags."
                }, {
                    type: "step",
                    title: "So reservieren Sie eine IP-Adresse:",
                    content: [
                        "1.	Klicken Sie Hinzufügen.",
                        "2.	Geben Sie die MAC-Adresse des betreffenden Gerätes ein.",
                        "3.	Geben Sie die zu reservierende IP-Adresse ein.",
                        "4.	Vergeben Sie eine kurze Beschreibung, damit Sie den Eintrag wiedererkennen können.",
                        "5.	Wählen Sie Aktivieren.",
                        "6.	Klicken Sie OK."
                    ]
                }, {
                    type: "step",
                    title: "Bearbeiten oder Löschen eines Eintrages",
                    content: "Klicken Sie in der Zeile des Gerätes Bearbeiten oder Löschen."
                }
            ]
        },
        DHCP_CLIENT_LIST: {
            TITLE: "DHCP-Clientliste",
            CONTENT: [
                {
                    type: "name",
                    title: "Clientanzahl",
                    content: "Laufende Nummer des DHCP-Clients."
                }, {
                    type: "name",
                    title: "Clientname",
                    content: "Hostname des DHCP-Clients."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "MAC-Adresse des DHCP-Clients."
                }, {
                    type: "name",
                    title: "Zugewiesene IP-Adresse",
                    content: "Die IP-Adresse, die dem DHCP-Client zugewiesen wurde."
                }, {
                    type: "name",
                    title: "Adresshaltezeit",
                    content: "Die Zeitdauer, für die der DHCP-Client seine Konfiguration behalten darf."
                }, {
                    type: "name",
                    title: "Neu laden",
                    content: "Ansicht der DHCP-Clientliste aktualisieren."
                }
            ]
        },
        DDNS: {
            TITLE: "Dynamisches DNS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Dynamisches DNS erlaubt Ihnen die Abbildung einer sich ändernden (dynamischen) IP-Adresse auf einen festen Host-/Domänennamen. Damit erreichen Sie die Serverdienste in Ihrem lokalen Netz (Webserver/FTP-Server/...) von außen stets unter der selben Adresse. All dies setzt die Anmeldung bei einem DDNS-Dienst (DynDNS oder No-IP) voraus."
                }, {
                    type: "step",
                    title: "So richten Sie Dynamisches DNS ein:",
                    content: ["1. Wählen Sie den DDNS-Anbieter, bei dem Sie sich registriert haben, aus.", "2. Geben Sie Benutzernamen und Passwort Ihres DDNS-Kontos ein.", "3. Geben Sie Ihren DDNS-Domänennamen ein.", "4. Wählen Sie aus der Drop-Down-Liste Ihr gewünschtes Aktualisierungsintervall aus.", "5. Klicken Sie Einloggen und Speichern."]
                }, {
                    type: "paragraph",
                    content: "Um zwischen verschiedenen DDNS-Konten zu wechseln, müssen Sie zunächst Logout klicken und dann mit den neuen Daten auf Login."
                }
            ]
        },
        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "Statisches Routing",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Statisches Routing legt eine Route fest, die Datenpakete gehen müssen, um ihr Ziel zu erreichen."
                }, {
                    type: "step",
                    title: "Einrichtung des Statischen Routings",
                    content: [
                        "1. Klicken Sie Hinzufügen.",
                        "2. Zielnetz - Geben Sie eine IP-Adresse in Hexadezimalschreibweise ein, um das Ziel der Route zu bestimmen.",
                        "3. Subnetzmaske - Geben Sie eine Subnetzmaske in Hexadezimalschreibweise ein, um die Netzgröße festzulegen.",
                        "4. Standard-Gateway - Geben Sie die Gateway-IP-Adresse dieser Statischen Route in Hexadezimalschreibweise ein.",
                        "5. Schnittstelle - Wählen Sie LAN oder WAN, um die für das Zielnetz zu verwendende Schnittstelle zu definieren.",
                        "6. Beschreibung - Eine kurze Beschreibung für diesen Eintrag.",
                        "7. Wählen Sie Aktivieren.",
                        "8. Klicken Sie OK."
                    ]
                }, {
                    type: "step",
                    title: "Bearbeiten oder Löschen eines Eintrages",
                    content: "Klicken Sie in der Zeile des Eintrages Bearbeiten oder Löschen."
                }
            ]
        },
        ADVANCED_ROUTING_SYSTEM_ROUTING: {
            TITLE: "Systemroutingtabelle",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Die Systemroutingtabelle zeigt alle aktuell verwendeten gültigen Routen an."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Neu laden, um die Ansicht der Routingtabelle zu aktualisieren."
                }
            ]
        },
        WIRELESS_REGION: {
            TITLE: "Einstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "Region",
                    content: " Wählen Sie aus der Drop-Down-Liste den Standort des Routers aus. Ist Ihr Standort nicht aufgeführt, wenden Sie sich an die zuständigen Behörden, um zu klären, ob der WLAN-Betrieb erlaubt ist."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Speichern</b>, um Ihre Einstellungen zu speichern."
                }
            ]
        },
        WIRELESS_BOTH: {
            TITLE: "WLAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Die untenstehenden Anweisungen gelten sowohl für <span class=\"anti_5g\">2,4- als auch 5GHz</span>-WLANs."
                }, {
                    type: "name",
                    title: "WLAN aktivieren",
                    content: "Wählen Sie dies aus, um Ihr WLAN zu aktivieren."
                }, {
                    type: "name",
                    title: "WLAN-Name (SSID)",
                    content: "Sie können die Standard-SSID belassen oder einen eigenen Namen vergeben (max. 32 Zeichen lang). Hier wird zwischen Groß- und Kleinschreibung unterschieden."
                }, {
                    type: "name",
                    title: "SSID verbergen",
                    content: "Wählen Sie dies aus, wenn Sie Ihr WLAN verstecken möchten."
                }, {
                    type: "name",
                    title: "Passwort",
                    content: "Vergeben Sie ein WLAN-Passwort aus 8 bis 63 ASCII-Zeichen oder 8 bis 64 Hexadezimalzeichen."
                }, {
                    type: "name",
                    title: "Erweitert",
                    content: "Klicken Sie hier, um die Erweiterten Einstellungen anzuzeigen."
                }, {
                    type: "name",
                    title: "Sicherheit",
                    content: "Wählen Sie hier eine der folgenden Optionen:",
                    children: [
                        {
                            type: "name",
                            title: "Keine Sicherheit",
                            content: "Wählen Sie diese Option, um Ihr WLAN unverschlüsselt zu betreiben. Es wird wärmstens <b>empfohlen</b>, dass Sie Ihr WLAN mit einem Passwort absichern, um unerlaubte Zugriffe zu unterbinden."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "(empfohlen) Authentifizierung basierend auf einem Passwort (PSK). Bitte beachten Sie die weiteren auszufüllenden Felder für diese Option.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Sicherheitsversion Ihres WLANs.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Automatisch",
                                            content: "Automatische Wahl zwischen WPA (Wi-Fi Protected Access) und WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Diese Option unterstützt TKIP- und AES-Verschlüsselung."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Diese Option bietet einen besseren Schutz als WPA-PSK und wird daher empfohlen."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Verschlüsselung",
                                    content: "Wählen Sie einen Sicherheitstyp aus: <b>TKIP</b> (Temporal Key Integrity Protokoll), <b>AES</b> (Advanced Encryption Standard) oder <b>Automatisch</b> (für automatische Wahl zwischen TKIP und AES). Die Verwendung von TKIP wird <b>NICHT</b> empfohlen, da TKIP für 802.11n nicht vorgesehen ist und Ihre Geräte dann nicht mit Wireless-N arbeiten werden."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Wählen Sie diese Option, um eine Grundauthentifizierung zu verwenden, falls Ihre Geräte kein WPA unterstützen (nicht empfohlen).",
                            children: [
                                {
                                    type: "name",
                                    title: "Typ",
                                    content: "Wählen Sie einen Authentifizierungstyp aus für Ihr WLAN: <b>Automatisch</b> (automatische Wahl, Standard), <b>Offen</b> oder <b>Shared-Key</b>."
                                }, {
                                    type: "name",
                                    title: "Ausgewählter Schlüssel",
                                    content: "Wählen Sie einen der vier Schlüssel aus."
                                }, {
                                    type: "name",
                                    title: "WEP-Schlüsselformat",
                                    content: "Wählen Sie entweder <b>ASCII</b> oder <b>Hexadezimal</b>. Bei ASCII können Sie Buchstaben und Ziffern verwenden. Bei Hexadezimal können Sie nur Hexadezimalziffern (0..9 und a..f) verwenden."
                                }, {
                                    type: "name",
                                    title: "Schlüsseltyp",
                                    content: "Die Länge des WEP-Schlüssels.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 Bit",
                                            content: "Geben Sie 10 Hexadezimalziffern (0..9, a..f) oder 5 ASCII-Zeichen ein."
                                        }, {
                                            type: "name",
                                            title: "128 Bit",
                                            content: "Geben Sie 26 Hexadezimalziffern (0..9, a..f) oder 13 ASCII-Zeichen ein."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modus",
                    content: "Wählen Sie einen Übertragungsmodus aus."
                }, {
                    type: "name",
                    title: "Kanalbreite",
                    content: "Wählen Sie hier die Kanalbreite Ihres WLANs aus."
                }, {
                    type: "name",
                    title: "Kanal",
                    content: "Wählen Sie hier, auf welchem Kanal Ihr WLAN laufen soll. Es wird empfohlen, den Kanal auf <b>Automatisch</b> zu belassen, es sei denn, Sie beobachten sporadische Verbindungsabbrüche."
                }, {
                    type: "name",
                    title: "Sendeleistung",
                    content: "Wählen Sie für die Sendeleistung entweder <b>Hoch</b>, <b>Mittel</b> oder <b>Niedrig</b>. Standard und empfohlen ist <b>Hoch</b>."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Speichern</b>, um Ihre Einstellungen zu speichern."
                }
            ]
        },
        WIRELESS_24G: {
            TITLE: "2,4GHz-WLAN",
            CONTENT: [
                {
                    type: "name",
                    title: "WLAN aktivieren",
                    content: "2,4GHz-WLAN aktivieren."
                }, {
                    type: "name",
                    title: "WLAN-Name (SSID)",
                    content: "Sie können die Standard-SSID belassen oder einen eigenen Namen vergeben (max. 32 Zeichen lang). Hier wird zwischen Groß- und Kleinschreibung unterschieden."
                }, {
                    type: "name",
                    title: "SSID verbergen",
                    content: "Wählen Sie diese Option, um Ihr 2,4GHz-WLAN zu verstecken."
                }, {
                    type: "name",
                    title: "Passwort",
                    content: "Vergeben Sie ein WLAN-Passwort aus 8 bis 63 ASCII-Zeichen oder 8 bis 64 Hexadezimalzeichen."
                }, {
                    type: "name",
                    title: "Erweitert",
                    content: "Klicken Sie, um zu den Erweiterten Einstellungen zu gelangen."
                }, {
                    type: "name",
                    title: "Sicherheit",
                    content: "Wählen Sie hier eine der folgenden Optionen:",
                    children: [
                        {
                            type: "name",
                            title: "Keine Sicherheit",
                            content: "Wählen Sie diese Option, um Ihr WLAN unverschlüsselt zu betreiben. Es wird wärmstens <b>empfohlen</b>, dass Sie Ihr WLAN mit einem Passwort absichern, um unerlaubte Zugriffe zu unterbinden."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "(empfohlen) Authentifizierung basierend auf einem Passwort (PSK). Bitte beachten Sie die weiteren auszufüllenden Felder für diese Option.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Sicherheitsversion Ihres WLANs.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Automatisch",
                                            content: "Automatische Wahl zwischen WPA (Wi-Fi Protected Access) und WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Diese Option unterstützt TKIP- und AES-Verschlüsselung."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Unterstützt AES und bietet ein höheres Maß an Sicherheit als WPA-PSK (empfohlen)."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Verschlüsselung",
                                    content: "Wählen Sie einen Sicherheitstyp aus: <b>TKIP</b> (Temporal Key Integrity Protokoll), <b>AES</b> (Advanced Encryption Standard) oder <b>Automatisch</b> (für automatische Wahl zwischen TKIP und AES). Die Verwendung von TKIP wird <b>NICHT</b> empfohlen, da TKIP für 802.11n nicht vorgesehen ist und Ihre Geräte dann nicht mit Wireless-N arbeiten werden."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Wählen Sie diese Option, um eine Grundauthentifizierung zu verwenden, falls Ihre Geräte kein WPA unterstützen (nicht empfohlen).",
                            children: [
                                {
                                    type: "name",
                                    title: "Typ",
                                    content: "Wählen Sie einen Authentifizierungstyp aus für Ihr WLAN: <b>Automatisch</b> (automatische Wahl, Standard), <b>Offen</b> oder <b>Shared-Key</b>."
                                }, {
                                    type: "name",
                                    title: "Ausgewählter Schlüssel",
                                    content: "Wählen Sie einen der vier Schlüssel aus."
                                }, {
                                    type: "name",
                                    title: "WEP-Schlüsselformat",
                                    content: "Wählen Sie entweder <b>ASCII</b> oder <b>Hexadezimal</b>. Bei ASCII können Sie Buchstaben und Ziffern verwenden. Bei Hexadezimal können Sie nur Hexadezimalziffern (0..9 und a..f) verwenden."
                                }, {
                                    type: "name",
                                    title: "Schlüsseltyp",
                                    content: "Die Länge des WEP-Schlüssels.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 Bit",
                                            content: "Geben Sie 10 Hexadezimalziffern (0..9, a..f) oder 5 ASCII-Zeichen ein."
                                        }, {
                                            type: "name",
                                            title: "128 Bit",
                                            content: "Geben Sie 26 Hexadezimalziffern (0..9, a..f) oder 13 ASCII-Zeichen ein."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modus",
                    content: "Wählen Sie einen Übertragungsmodus aus."
                }, {
                    type: "name",
                    title: "Kanalbreite",
                    content: "Die von Ihrem 2,4GHz-WLAN verwendete Bandbreite pro Kanal."
                }, {
                    type: "name",
                    title: "Kanal",
                    content: "Wählen Sie hier, auf welchem Kanal Ihr WLAN laufen soll. Es wird empfohlen, den Kanal auf <b>Automatisch</b> zu belassen, es sei denn, Sie beobachten sporadische Verbindungsabbrüche."
                }, {
                    type: "name",
                    title: "Sendeleistung",
                    content: "Wählen Sie für die Sendeleistung entweder <b>Hoch</b>, <b>Mittel</b> oder <b>Niedrig</b>. Standard und empfohlen ist <b>Hoch</b>."
                }
            ]
        },
        WIRELESS_5G: {
            TITLE: "5GHz-WLAN",
            CONTENT: [
                {
                    type: "name",
                    title: "WLAN aktivieren",
                    content: "5GHz-WLAN aktivieren."
                }, {
                    type: "name",
                    title: "WLAN-Name (SSID)",
                    content: "Sie können die Standard-SSID belassen oder einen eigenen Namen vergeben (max. 32 Zeichen lang). Hier wird zwischen Groß- und Kleinschreibung unterschieden."
                }, {
                    type: "name",
                    title: "SSID verbergen",
                    content: "Wählen Sie diese Option, um Ihr 5GHz-WLAN zu verstecken."
                }, {
                    type: "name",
                    title: "Passwort",
                    content: "Vergeben Sie ein WLAN-Passwort aus 8 bis 63 ASCII-Zeichen oder 8 bis 64 Hexadezimalzeichen."
                }, {
                    type: "name",
                    title: "Erweitert",
                    content: "Klicken Sie, um zu den Erweiterten Einstellungen zu gelangen."
                }, {
                    type: "name",
                    title: "Sicherheit",
                    content: "Wählen Sie hier eine der folgenden Optionen:",
                    children: [
                        {
                            type: "name",
                            title: "Keine Sicherheit",
                            content: "Hiermit deaktivieren Sie Ihre WLAN-Verschlüsselung. Es wird wärmstens empfohlen, Ihr Gast-WLAN nur verschlüsselt zu betreiben."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "(empfohlen) Authentifizierung basierend auf einem Passwort (PSK). Bitte beachten Sie die weiteren auszufüllenden Felder für diese Option.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Sicherheitsversion Ihres WLANs.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Automatisch",
                                            content: "Automatische Wahl zwischen WPA (Wi-Fi Protected Access) und WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Diese Option unterstützt TKIP- und AES-Verschlüsselung."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Unterstützt AES und bietet ein höheres Maß an Sicherheit als WPA-PSK (empfohlen)."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Verschlüsselung",
                                    content: "Wählen Sie einen Sicherheitstyp aus: <b>TKIP</b> (Temporal Key Integrity Protokoll), <b>AES</b> (Advanced Encryption Standard) oder <b>Automatisch</b> (für automatische Wahl zwischen TKIP und AES). Die Verwendung von TKIP wird <b>NICHT</b> empfohlen, da TKIP für 802.11n nicht vorgesehen ist und Ihre Geräte dann nicht mit Wireless-N arbeiten werden."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "(nicht empfohlen) Wählen Sie diese veraltete Authentifizierungsmethode nur dann aus, wenn Ihre WLAN-Geräte kein WPA(2) unterstützen.",
                            children: [
                                {
                                    type: "name",
                                    title: "Typ",
                                    content: "Wählen Sie einen Authentifizierungstyp für Ihr WLAN. Standardwert ist <b>Automatisch</b>, wodurch automatisch zwischen <b>Offen</b> und <b>Shared-Key</b> gewählt wird."
                                }, {
                                    type: "name",
                                    title: "Ausgewählter Schlüssel",
                                    content: "Wählen Sie einen der vier Schlüssel aus."
                                }, {
                                    type: "name",
                                    title: "WEP-Schlüsselformat",
                                    content: "Wählen Sie entweder <b>ASCII</b> oder <b>Hexadezimal</b>. Bei ASCII können Sie Buchstaben und Ziffern verwenden. Bei Hexadezimal können Sie nur Hexadezimalziffern (0..9 und a..f) verwenden."
                                }, {
                                    type: "name",
                                    title: "Schlüsseltyp",
                                    content: "Die Länge des WEP-Schlüssels.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 Bit",
                                            content: "Geben Sie 10 Hexadezimalziffern (0..9, a..f) oder 5 ASCII-Zeichen ein."
                                        }, {
                                            type: "name",
                                            title: "128 Bit",
                                            content: "Geben Sie 26 Hexadezimalziffern (0..9, a..f) oder 13 ASCII-Zeichen ein."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modus",
                    content: "Wählen Sie einen Übertragungsmodus aus."
                }, {
                    type: "name",
                    title: "Kanalbreite",
                    content: "Die von Ihrem 5GHz-WLAN verwendete Bandbreite pro Kanal."
                }, {
                    type: "name",
                    title: "Kanal",
                    content: "Wählen Sie den zu verwendenden 5GHz-Kanal aus. Es wird empfohlen, die Standardeinstellung (Auto) beizubehalten, sofern keine anderen Gründe dagegen sprechen."
                }, {
                    type: "name",
                    title: "Sendeleistung",
                    content: "Wählen Sie zwischen Hoch, Mittel oder Niedrig. Der Standardwert ist Hoch (empfohlen)."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Speichern, um Ihre Einstellungen zu übernehmen."
                }
            ]
        },
        WIFI_TIME_CONTROL: {
            TITLE: "WLAN-Zeitplan",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "WLAN-Planung erlaubt Ihnen das Abschalten Ihres WLANs für Zeiten, in denen es nicht gebraucht wird."
                }, {
                    type: "name",
                    title: "WLAN-Planer",
                    content: "<b>Aktivieren</b> der WLAN-Planung. Soll das WLAN aktiv bleiben, solange Geräte verbunden sind, wählen Sie die Option an."
                }
            ]
        },
        WIFI_CLONE: {
            TITLE: "WiFi-Clone",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mittels WiFi-Clone kopieren Sie die Einstellungen (SSID und WLAN-Passwort) von Ihrem WLAN auf Ihren Powerline-Adapter."
                }, {
                    type: "name",
                    title: "Auswahl des WLAN-Bandes",
                    content: "Wählen Sie das zu klonende Band <span class=\"anti_5g\">bzw. Bänder</span>.<span>Unterstützt Ihr Router das Klonen nur für ein Band zugleich, wird empfohlen, hier 2,4GHz & 5GHz zu wählen, damit das geklonte Band mit dem Ihres Routers übereinstimmt.</span>"
                }
            ]
        },
        WIFI_TIME_GRID: {
            TITLE: "Zeitraum, in dem Ihr WLAN ausgeschaltet ist",
            CONTENT: [
                {
                    type: "name",
                    title: "Von",
                    content: "Die Zeit, zu der Ihr WLAN abgeschaltet werden soll."
                }, {
                    type: "name",
                    title: "An",
                    content: "Die Zeit, zu der Ihr WLAN eingeschaltet werden soll."
                }, {
                    type: "name",
                    title: "Wochentag(e)",
                    content: "Die Wochentage, zu denen der Plan gelten soll."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Zeigt an, ob der Plan aktiviert ist. Klicken Sie die Birne, um den Plan zu (de)aktivieren."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Bietet Optionen zum <b>Bearbeiten</b> oder <b>Löschen</b> eines Eintrags."
                }, {
                    type: "step",
                    title: "Hinzufügen eines neuen Zeitplans",
                    content: ["1. Klicken Sie <b>Hinzufügen</b>.", "2. Geben Sie den Zeitraum an, zu dem Ihr WLAN abgeschaltet sein soll.", "3. Wählen Sie die Wochentage.", "4. Wählen Sie <b>Eintrag aktivieren</b>.", "5. Klicken Sie <b>OK</b>, um den Eintrag zu speichern."]
                }, {
                    type: "paragraph",
                    content: "Um einen Eintrag zu bearbeiten oder zu löschen, klicken Sie einfach <b>Bearbeiten</b> bzw. die <b>Mülltonne</b>."
                }, {
                    type: "paragraph",
                    content: "Um mehrere Zeitpläne zu löschen, wählen Sie alle an und klicken Sie oberhalb der Tabelle <b>Löschen</b>."
                }
            ]
        },
        WPS: {
            TITLE: "PIN des Routers",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Sie können Ihre WLAN-Geräte unter Verwendung der WPS-PIN des Routers mit Ihrem WLAN verbinden."
                }, {
                    type: "name",
                    title: "Router-PIN aktivieren",
                    content: "WLAN-Geräten die Verbindung mittels Router-PIN erlauben."
                }, {
                    type: "name",
                    title: "Router-PIN",
                    content: "Die PIN Ihres Routers. Die Standard-PIN kann auf einem Aufkleber am Router gefunden werden oder im Handbuch. Klicken Sie Erzeugen, um eine neue, zufällige PIN zu erstellen. Klicken Sie Standard, um die Original-PIN wiederherzustellen."
                }
            ]
        },
        WPS_WIZARD: {
            TITLE: "WPS-Assistent",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wählen Sie eine Einrichtungsmethode"
                }, {
                    type: "name",
                    title: "Push-Button-Methode",
                    content: "Erlauben, dass Geräte sich mittels WPS-Tastendruck verbinden (empfohlen)."
                }, {
                    type: "name",
                    title: "PIN",
                    content: "Wählen Sie diese Methode, um ein Gerät mittels Eingabe von dessen PIN in den Router, gefolgt von einem Klick auf Verbinden, mit dem WLAN zu verbinden."
                }
            ]
        },
        WIRELESS_STATISTICS: {
            TITLE: "WLAN-Geräte online",
            CONTENT: [
                {
                    type: "name",
                    title: "Clients insgesamt",
                    content: "Die Gesamtanzahl der mit Ihrem Powerlinenetz verbundenen WLAN-Geräte."
                }, {
                    type: "name",
                    title: "Gerätename",
                    content: "Der Name des drahtlos verbundenen Gerätes."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Die vom Gerät verwendete IP-Adresse."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die MAC-Adresse des WLAN-Gerätes."
                }, {
                    type: "name",
                    title: "WLAN-Band",
                    content: "Die Betriebsfrequenz <span class=\"anti_5g\">(2,4GHz oder 5GHz)</span> des WLANs, mit dem das Gerät verbunden ist."
                }, {
                    type: "name",
                    title: "Sicherheit",
                    content: "Der vom Gerät verwendete Sicherheitstyp."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Neu laden</b>, um die auf dieser Seite gezeigten Informationen zu aktualisieren."
                }
            ]
        },
        GUEST_NETWORK_BASIC: {
            TITLE: "Gastnetz",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Das <b>Gastnetz</b> ermöglicht Ihnen die Errichtung eines separaten WLANs (extra WLAN-Name (SSID) und Passwort) für Ihre Gäste."
                }
            ]
        },
        GUEST_NETWORK_SETTINGS: {
            TITLE: "Gastnetz",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Das <b>Gastnetz</b> ermöglicht Ihnen die Errichtung eines separaten WLANs (extra WLAN-Name (SSID) und Passwort) für Ihre Gäste."
                }, {
                    type: "name",
                    title: "Gäste dürfen einander sehen",
                    content: "Wählen Sie dies aus, um die Gastnetzteilnehmer miteinander kommunizieren zu lassen."
                }, {
                    type: "name",
                    title: "Gäste dürfen nicht auf die Routeroberfläche zugreifen",
                    content: "Wählen Sie diese Option, um zu verhindern, dass Ihre Gäste auf die Weboberfläche Ihres Routers zugreifen."
                }, {
                    type: "name",
                    title: "Automatisch abschalten nach",
                    content: "Wählen Sie diese Option, um Ihr Gast-WLAN zur angegebenen Uhrzeit automatisch abzuschalten."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Speichern</b>, um all Ihre Einstellungen zu speichern."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS: {
            TITLE: "Gastnetzeinstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "2,4GHz | 5GHz",
                    content: "Schalten Sie zwischen 2,4- und 5GHz-Einstellungen um."
                }, {
                    type: "name",
                    title: "Gastnetz aktivieren",
                    content: "Wählen Sie dies aus, um das Gastnetz zu aktivieren."
                }, {
                    type: "name",
                    title: "WLAN-Name (SSID)",
                    content: "Gast-WLAN-Name, kann frei gewählt werden (1 bis 32 Zeichen)."
                }, {
                    type: "name",
                    title: "Sicherheit",
                    content: "Wählen Sie hier eine der folgenden Optionen:",
                    children: [
                        {
                            type: "name",
                            title: "Keine Sicherheit",
                            content: "Wählen Sie diese Option, um Ihr WLAN unverschlüsselt zu betreiben. Es wird wärmstens <b>empfohlen</b>, dass Sie Ihr WLAN mit einem Passwort absichern, um unerlaubte Zugriffe zu unterbinden."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Personal",
                            content: "Aktivieren der Standardauthentifizierung basierend auf einem Passwort (PSK). Dies ist die Standard-Verschlüsselungsmethode in Heim-WLANs und umfasst folgende Parameter:"
                        }
                    ]
                }, {
                    type: "name",
                    title: "Passwort",
                    content: "Vergeben Sie ein WLAN-Passwort aus 8 bis 63 ASCII-Zeichen oder 8 bis 64 Hexadezimalzeichen."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Speichern</b>, um Ihre Gast-WLAN-Einstellungen zu speichern."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "WLAN-Einstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "Gastnetz aktivieren",
                    content: "Aktivieren des Gastnetzes."
                }, {
                    type: "name",
                    title: "WLAN-Name (SSID)",
                    content: "Gast-WLAN-Name, kann frei gewählt werden (1 bis 32 Zeichen)."
                }, {
                    type: "name",
                    title: "Sicherheit",
                    content: "Wählen Sie hier eine der folgenden Optionen:",
                    children: [
                        {
                            type: "name",
                            title: "Keine Sicherheit",
                            content: "Wählen Sie diese Option, um Ihr WLAN unverschlüsselt zu betreiben. Es wird wärmstens <b>empfohlen</b>, dass Sie Ihr WLAN mit einem Passwort absichern, um unerlaubte Zugriffe zu unterbinden."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Personal",
                            content: "Aktivieren der Standardauthentifizierung basierend auf einem Passwort (PSK). Dies ist die Standard-Verschlüsselungsmethode in Heim-WLANs und umfasst folgende Parameter:"
                        }
                    ]
                }, {
                    type: "name",
                    title: "Passwort",
                    content: "Vergeben Sie ein WLAN-Passwort aus 8 bis 63 ASCII-Zeichen oder 8 bis 64 Hexadezimalzeichen."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Speichern</b>, um Ihre Gast-WLAN-Einstellungen zu speichern."
                }
            ]
        },
        NAT: {
            TITLE: "Application Layer Gateway(ALG)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ALG erlaubt benutzerdefinierte NAT(Network Address Translation)-Filter, die den Betrieb von Anwendungen wie FTP, TFTP, H323 usw. ermöglichen. Es wird empfohlen, das ALG zu benutzen."
                }, {
                    type: "name",
                    title: "FTP-ALG aktivieren",
                    content: "Erlaubt FTP(File Transfer Protocol)-Clients und -Servern, Daten durch einen NAT-Router zu transferieren."
                }, {
                    type: "name",
                    title: "TFTP-ALG aktivieren",
                    content: "Erlaubt TFTP(Trivial File Transfer Protocol)-Clients und -Servern, Daten durch einen NAT-Router zu transferieren."
                }, {
                    type: "name",
                    title: "H323-ALG aktivieren",
                    content: "Erlaubt Microsoft-Netmeeting-Clients, durch einen NAT-Router zu kommunizieren."
                }, {
                    type: "name",
                    title: "RTSP-ALG aktivieren",
                    content: "Erlaubt Media-Playern, durch einen NAT-Router mit Streamingservern zu kommunizieren."
                }, {
                    type: "name",
                    title: "PPTP-Passthrough aktivieren",
                    content: "Erlaubt das Tunneln von Punkt-zu-Punkt-Sessions durch ein IP-Netz und durch den Router."
                }, {
                    type: "name",
                    title: "L2TP-Passthrough aktivieren",
                    content: "Erlaubt das Tunneln von Layer2-Punkt-zu-Punkt-Sessions durch ein IP-Netz und durch den Router."
                }, {
                    type: "name",
                    title: "IPsec-Passthrough aktivieren",
                    content: "Erlaubt das Tunneln von IPsec(Internet Protocol Security)-Sessions durch ein IP-Netz und durch den Router. IPsec verwendet eine starke Verschlüsselung, um Ihre Daten sicher durch IP-Netze zu transportieren."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Speichern, um Ihre Einstellungen zu übernehmen."
                }
            ]
        },
        VIRTUAL_SERVERS: {
            TITLE: "Virtuelle Server",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Virtuelle Server werden verwendet, um Dienste aus dem lokalen Netz auch im Internet verfügbar zu machen. Bei der Konfiguration eines Virtuellen Servers geben Sie einen externen Port(bereich) und eine lokale IP-Adresse an. Verbindungsanfragen auf diesem Port werden dann an die angegebene lokale IP-Adresse weitergereicht. Naturgemäß muss diese IP-Adresse statisch sein (von Hand konfiguriert oder im DHCP-Server reserviert)."
                }, {
                    type: "name",
                    title: "Diensttyp",
                    content: "Name des Virtuellen Servers."
                }, {
                    type: "name",
                    title: "Externer Port",
                    content: "Vom Virtuellen Server verwendeter Port(bereich)."
                }, {
                    type: "name",
                    title: "Interne IP-Adresse",
                    content: "Lokale IP-Adresse des Servers, auf dem der Dienst des Virtuellen Servers läuft."
                }, {
                    type: "name",
                    title: "Interner Port",
                    content: "Port, auf dem der Dienst des Virtuellen Servers läuft."
                }, {
                    type: "name",
                    title: "Protokoll",
                    content: "Das Protokoll, das der Dienst benutzt: TCP, UDP oder Alle (alle vom Router unterstützten Protokolle)."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Aktueller Status der Regel (aktiviert oder deaktiviert)."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Hier haben Sie die Möglichkeit, einen Virtuellen Server zu Bearbeiten oder zu Löschen."
                }, {
                    type: "step",
                    title: "Einrichten eines Virtuellen Servers",
                    content: ["1.	Klicken Sie Hinzufügen.", "2. Ist Ihre Applikation in der Drop-Down-Liste Gebräuchliche Dienste zu finden, wählen Sie sie dort aus. Dann werden die Felder Externer Port und Interner Port automatisch befüllt. Ansonsten tragen Sie die Portnummer(n) bitte selbst von Hand ein (Beispiel: 21-25). Lassen Sie das Feld Interner Port frei, wird der externe Port in dieses Feld übernommen. Geben Sie zum Schluss die IP-Adresse des Servers in das Feld Interne IP-Adresse ein.", "3.	Wählen Sie das für Ihre Applikation zu verwendende Protokoll: TCP, UDP oder Alle.", "4.	Wählen Sie Aktivieren.", "5. Klicken Sie OK."]
                }, {
                    type: "step",
                    title: "So bearbeiten/löschen Sie einen Virtuellen Server:",
                    content: "Klicken Sie in der zugehörigen Zeile Bearbeiten oder Löschen."
                }, {
                    type: "step",
                    title: "Löschen mehrerer Virtueller Server:",
                    content: "Wählen sie die zu löschenden Einträge an und klicken Sie oberhalb der Tabelle auf Löschen."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Laufen auf Ihrem Server mehrere Dienste, die Sie über das Internet zugänglich machen wollen, benötigen Sie pro Dienst einen Eintrag in der Tabelle der Virtuellen Server."
                }
            ]
        },
        PORT_TRIGGERING: {
            TITLE: "Port-Triggering",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Porttriggering wird verwendet, damit bestimmte Applikationen trotz Einsatzes eines NAT-Routers funktionieren."
                }, {
                    type: "name",
                    title: "Applikation",
                    content: "Name der Applikation."
                }, {
                    type: "name",
                    title: "Triggerport",
                    content: "Port, auf dem eine ausgehende Verbindung das Inkrafttreten der Triggerregel auslöst."
                }, {
                    type: "name",
                    title: "Trigger-Protokoll",
                    content: "Das Protokoll, das auf dem Triggerport verwendet wird: TCP, UDP oder Alle (alle vom Router unterstützten Protokolle)."
                }, {
                    type: "name",
                    title: "Externer Port",
                    content: "Der Port(bereich), der durch die Regel für den Trigger-PC geöffnet werden soll. Sie können hier bis zu 5 Portgruppen angeben. Diese müssen durch Kommata getrennt werden. Beispiel: 2000-2038, 2046, 2050-2051, 2085, 3010-3030."
                }, {
                    type: "name",
                    title: "Externes Protokoll",
                    content: "Das Protokoll, das die eingehenden Verbindungen verwenden dürfen: TCP, UDP oder Alle (alle vom Router unterstützten Protokolle)."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Aktueller Status der Regel (aktiviert oder deaktiviert)."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Zeigt Optionen zum Bearbeiten bzw. Löschen einer Regel."
                }, {
                    type: "step",
                    title: "So richten Sie eine Porttriggeringregel ein:",
                    content: [
                        {
                            type: "note",
                            title: "Hinweis",
                            content: "Jede Regel kann nur von einem LAN-Teilnehmer zugleich benutzt werden."
                        },
                        "1. Klicken Sie Hinzufügen.", {
                            content: "2. Klicken Sie Gebräuchliche Applikationen, um die Felder Applikation, Triggerport, Triggerprotokoll, Externer Port und Externes Protokoll automatisch auszufüllen oder füllen Sie sie von Hand aus.",
                            children: [
                                {
                                    type: "note",
                                    title: "Hinweis",
                                    content: "Die von den verschiedenen Triggeringregeln verwendeten Portbereiche dürfen einander nicht überlappen, d.h. die Portbereiche 4200-4205 und 4203-4206 können nicht zugleich verwendet werden."
                                }
                            ]
                        },
                        "3. Wählen Sie Aktivieren.",
                        "4. Klicken Sie OK."
                    ]
                }, {
                    type: "step",
                    title: "So bearbeiten/löschen Sie eine Porttriggeringregel:",
                    content: "Klicken Sie in der zugehörigen Zeile Bearbeiten oder Löschen."
                }, {
                    type: "step",
                    title: "Löschen mehrerer Porttriggeringregeln:",
                    content: "Wählen Sie alle zu löschenden Einträge aus und klicken Sie oberhalb der Tabelle Löschen."
                }
            ]
        },
        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Die Funktion DMZ(Demilitarisierte Zone)-Host macht ein Gerät in Ihrem lokalen Netz aus dem Internet komplett sichtbar. Dies ist hilfreich für Internetgaming oder Videokonferenzen. Naturgemäß muss diese IP-Adresse statisch sein (von Hand konfiguriert oder im DHCP-Server reserviert)."
                }, {
                    type: "step",
                    title: "So machen Sie einen Computer zum DMZ-Server:",
                    content: ["1. Klicken Sie DMZ aktivieren.", "2. In das Feld IP-Adresse des DMZ-Hosts geben Sie die IP-Adresse eines lokalen Computers ein.", "3. Klicken Sie Speichern."]
                }
            ]
        },
        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Standardmäßig ist Universal Plug-and-Play (UPnP) aktiviert, damit UPnP-Geräte ohne weitere Konfigurationsschritte miteinander kommunizieren können."
                }, {
                    type: "paragraph",
                    content: "Die UPnP-Serviceliste zeigt Ihnen Informationen zu den aktiven UPnP-Geräten in Ihrem Netz."
                }, {
                    type: "name",
                    title: "Dienstbeschreibung",
                    content: "Kurze Beschreibung des Hosts, der die UPnP-Anfrage gestellt hat."
                }, {
                    type: "name",
                    title: "Externer Port",
                    content: "Externer, für den Host zu öffnender Port."
                }, {
                    type: "name",
                    title: "Protokoll",
                    content: "Das vom Host verwendete Protokoll."
                }, {
                    type: "name",
                    title: "Interne IP-Adresse",
                    content: "IP-Adresse des lokalen Gerätes."
                }, {
                    type: "name",
                    title: "Interner Port",
                    content: "Interner, für den Host zu öffnender Port."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Aktualisieren, um die Ansicht neu zu laden."
                }
            ]
        },
        DISK_SETTING: {
            TITLE: "Geräteeinstellungen",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Auf der Seite Geräteeinstellungen sehen Sie Informationen zu am USB-Port angeschlossenen Geräten."
                }, {
                    type: "name",
                    title: "Suchen",
                    content: "Normalerweise findet der Router neu angeschlossene USB-Geräte automatisch. Mit dieser Schaltfläche können Sie angeschlossene USB-Geräte manuell erkennen lassen."
                }, {
                    type: "name",
                    title: "Name",
                    content: "Zeigt den Namen der Partition."
                }, {
                    type: "name",
                    title: "Kapazität",
                    content: "Gesamtkapazität des USB-Datenträgers"
                }, {
                    type: "name",
                    title: "Freier Speicherplatz",
                    content: "Aktuell verfügbarer Speicherplatz auf dem USB-Datenträger."
                }, {
                    type: "name",
                    title: "Sicher entfernen",
                    content: "Klicken Sie hier, bevor Sie das USB-Gerät physisch vom Router entfernen."
                }, {
                    type: "paragraph",
                    content: "Die Schaltfläche Sicher entfernen erscheint nur, wenn ein USB-Datenträger an den Router angeschlossen ist. Ein Entfernen ist nicht möglich, solange das USB-Gerät in Verwendung ist."
                }, {
                    type: "name",
                    title: "Aktiv",
                    content: "Diese Option erscheint nur, wenn ein USB-Datenträger an den Router angeschlossen ist. Aktiviert die Freigabe des USB-Geräts."
                }, {
                    type: "step",
                    title: "Einrichtung eines Fileservers",
                    content: ["1. Schließen Sie das USB-Speichergerät mittels eines USB-Kabels an den Router an.", "2. Neu angeschlossene USB-Geräte werden vom Router automatisch erkannt und unter Geräteeinstellungen angezeigt. Ist dies nicht der Fall, klicken Sie Suchen.", "3. Wählen Sie Dateifreigabe aktivieren."]
                }
            ]
        },
        FOLDER_SHARE_ACCOUNT: {
            TITLE: "Benutzerkonto",
            CONTENT: [
                {
                    type: "name",
                    title: "Benutzerkonto",
                    content: "Sie können entweder Standardaccount oder Neues Benutzerkonto wählen."
                }, {
                    type: "name",
                    title: "Benutzername/Passwort",
                    content: "Geben Sie einen Benutzernamen, der Buchstaben, Ziffern und Unterstriche enthalten darf, ein. Der Benutzername muss mit einem Buchstaben beginnen und darf nicht länger als 15 Zeichen sein. Es wird zwischen Groß- und Kleinschreibung unterschieden."
                }, {
                    type: "name",
                    title: "Passwort bestätigen",
                    content: "Geben Sie Ihr Passwort hier erneut ein, um Tippfehler auszuschließen."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Speichern, um Ihre eingegebenen Daten zu speichern."
                }
            ]
        },
        FOLDER_SHARE_SETTINGS: {
            TITLE: "Freigabeeinstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "Netz-/Mediaserver-Name",
                    content: "Der Name, unter dem der angeschlossene USB-Datenträger erreichbar ist."
                }, {
                    type: "name",
                    title: "Aktivieren",
                    content: "Zugriff zulassen."
                }, {
                    type: "name",
                    title: "Zugriffsmethode",
                    content: "Es existieren drei Möglichkeiten, auf den angeschlossenen USB-Datenträger zuzugreifen. Wählen Sie von diesen mindestens eine aus.",
                    children: [
                        {
                            type: "name",
                            title: "Samba/UNC",
                            content: "Ist es aktiviert, können die Teilnehmer in Ihrem Netz unter Verwendung der IP-Adresse (z.B. \\\\192.168.0.1) auf den USB-Datenträger zugreifen. Diese Methode ist standardmäßig aktiviert."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "Ist es aktiviert, können FTP-Clients in Ihrem lokalen Netz über die IP-Adresse und die Portnummer (z.B. ftp://192.168.0.1:21) auf den USB-Datenträger zugreifen."
                        }, {
                            type: "name",
                            title: "FTP über Internet",
                            content: "Ist es aktiviert, können FTP-Clients aus der Ferne auf den USB-Datenträger zugreifen, um Dateien herunter- und hinaufzuladen. Um die Portnummer des FTP-Dienstes zu ändern, geben Sie eine neue Portnummer ein und klicken Sie Speichern."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Link",
                    content: "Stellt einen Link zum Öffnen des Datenträgers zur Verfügung."
                }, {
                    type: "name",
                    title: "Port",
                    content: "Nummer des Ports, auf dem der FTP-Dienst läuft."
                }
            ]
        },
        FOLDER_SHARE_FOLDERS: {
            TITLE: "Ordnerfreigabe",
            CONTENT: [
                {
                    type: "name",
                    title: "Komplett freigeben",
                    content: "Ermöglicht die Freigabe des ganzen USB-Datenträgers. Möchten Sie nur einzelne Ordner freigeben, deaktivieren Sie diese Option."
                }, {
                    type: "name",
                    title: "Authentifizierung aktivieren",
                    content: "Es wird empfohlen, die Authentifizierung zu aktivieren, so dass jeder, der auf den Datenträger zugreifen möchte, Benutzernamen und Passwort braucht."
                }, {
                    type: "name",
                    title: "Ordnername",
                    content: "Name des freigegebenen Ordners."
                }, {
                    type: "name",
                    title: "Ordnerpfad",
                    content: "Der Pfad zu dem freigegebenen Ordner."
                }, {
                    type: "name",
                    title: "Medienfreigabe",
                    content: "Erlaubt dem Mediaserver die Verwendung dieses Ordners."
                }, {
                    type: "name",
                    title: "Datenträgername",
                    content: "Name des freigegebenen Datenträgers."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Zeigt den Status des freigegebenen Ordners an. Grün (EIN) ist aktiviert und Grau (AUS) ist deaktiviert. Der Status kann durch einen Klick auf die Glühbirne umgeschaltet werden."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Bearbeiten oder Löschen einer Freigabe."
                }, {
                    type: "name",
                    title: "Durchsuchen",
                    content: "Klicken Sie hier, um einen freizugebenden Ordner herauszusuchen."
                }, {
                    type: "name",
                    title: "Zugriff aus dem Gastnetz erlauben",
                    content: "Bestimmt, ob die Teilnehmer Ihres Gastnetzes Zugriff auf die Freigabe bekommen."
                }, {
                    type: "name",
                    title: "Authentifizierung aktivieren",
                    content: "Ist dies aktiviert, müssen Benutzer einen Namen und ein Passwort eingeben, um Zugriff auf die freigegebenen Ordner zu erhalten (empfohlen)."
                }, {
                    type: "name",
                    title: "Schreibzugriff erlauben",
                    content: "Erlaubt dem Benutzer das Verändern von Datenträgerinhalten."
                }, {
                    type: "name",
                    title: "Medienfreigabe",
                    content: "Erlaubt dem Mediaserver die Verwendung dieses Ordners."
                }
            ]
        },
        PRINT_SERVER: {
            TITLE: "Printserver",
            CONTENT: [
                {
                    type: "step",
                    title: "So richten Sie auf Ihrem Router einen Printserver ein:",
                    content: ["1. Verbinden Sie einen unterstützten USB-Drucker mit dem USB-Port des Routers.", "2. Installieren Sie auf Ihrem Computer den Druckertreiber. Details hierzu finden Sie im Druckerhandbuch.", "3. Installieren Sie TP-Links USB-Printer-Controller-Utility, entweder von der CD (nur für Windows) oder von TP-Links Webpräsenz heruntergeladen (sowohl für Windows als auch für Mac OS X)."]
                }
            ]
        },
        PARENTAL_CONTROL: {
            TITLE: "Kindersicherung",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mit der Kindersicherung können Sie für Ihre WLAN-Geräte Zeitpläne erstellen und angeben, wann diese Geräte auf das Internet zugreifen können."
                }, {
                    type: "name",
                    title: "Kindersicherung",
                    content: "<b>Aktivieren</b> Sie dies, um die Kindersicherung zu nutzen."
                }
            ]
        },
        PARENTAL_CONTROL_DEVICES: {
            TITLE: "Der Kindersicherung unterliegende Geräte",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "Laufende Nummer des Clientgerätes."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die MAC-Adresse des Clientgerätes."
                }, {
                    type: "name",
                    title: "Internetzugriffszeit",
                    content: "Zeigt den Zeitraum, in dem Zugriffe erlaubt sind."
                }, {
                    type: "name",
                    title: "Beschreibung",
                    content: "Kurze Beschreibung des Gerätes."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Zeigt an, ob die Kindersicherung für das Gerät aktiviert ist."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Zeigt Optionen zum <b>Bearbeiten</b> oder <b>Löschen</b> des Geräts."
                }, {
                    type: "step",
                    title: "Einem neuen Clientgerät ein Zeitlimit zuweisen",
                    content: [
                        "1. Klicken Sie <b>Hinzufügen</b>.",
                        "2. Klicken Sie <b>Existierende Geräte</b> und wählen Sie ein aktuell verbundenes Gerät aus der Liste <b>Zugriff über WLAN Gerät</b> oder geben Sie die <b>MAC-Adresse</b> des Geräts von Hand ein, z.B. falls es aktuell nicht verbunden ist.",
                        "3. Klicken Sie auf das Symbol <b>Internetzugriffszeit</b>, um Zeiträume zu definieren, in denen dieses Gerät Internetzugriff haben soll.",
                        "4. Vergeben Sie im Feld <b>Beschreibung</b> eine Beschreibung (optional).",
                        "5. Wählen Sie <b>Diesen Eintrag aktivieren</b>.",
                        "6. Klicken Sie <b>OK</b>, um den Eintrag zu speichern."
                    ]
                }, {
                    type: "paragraph",
                    content: "Bearbeiten oder Löschen eines Gerätes aus der Liste. Klicken Sie einfach <b>Bearbeiten</b> oder die <b>Mülltonne</b>."
                }, {
                    type: "paragraph",
                    content: "Löschen mehrerer Geräte aus der Liste. Wählen Sie die zu löschenden Geräte an und klicken Sie oberhalb der Tabelle <b>Löschen</b>."
                }
            ]
        },
        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "Contentfilter",
            CONTENT: [
                {
                    type: "name",
                    title: "Blacklist",
                    content: "Enthält Schlüsselwörter, anhand derer Zugriffe Ihrer der Kindersicherung unterliegenden Clientgeräte auf bestimmte Webpräsenzen unterbunden werden.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Klicken Sie Schlüsselwort hinzufügen, um ein Schlüsselwort zur Blacklist hinzuzufügen. Um eines zu löschen, klicken Sie für dieses Schlüsselwort (-)."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Whitelist",
                    content: "Enthält Adressen von Webpräsenzen, auf die der Kindersicherung unterliegende Clientgeräte zugreifen dürfen.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Klicken Sie Neuen Domänennamen hinzufügen, um eine neue Domäne zur Whitelist hinzuzufügen. Um eine zu löschen, klicken Sie für diese Domäne (-)."
                        }
                    ]
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Schlüsselwörter können auch Domänennamen sein, z.B. www.example.com."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Speichern, um Ihre Konfiguration zu speichern."
                }
            ]
        },
        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Quality of Service (QoS) priorisiert den Internetdatenverkehr entsprechend Ihren Vorgaben. Sie können die Prioritätsebene für ein Gerät oder eine Applikation in der QoS-Regelliste angeben."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Ist NAT-Boost aktiviert, muss QoS deaktiviert sein."
                }, {
                    type: "name",
                    title: "QoS aktivieren",
                    content: "Aktivieren der QoS-Funktion."
                }, {
                    type: "name",
                    title: "Upload-Datenrate",
                    content: "Geben Sie hier die maximal mögliche Uploadgeschwindigkeit Ihrer Leitung ein (Internetdiensteanbieter)."
                }, {
                    type: "name",
                    title: "Download-Datenrate",
                    content: "Geben Sie hier die maximal mögliche Downloadgeschwindigkeit Ihrer Leitung ein."
                }, {
                    type: "name",
                    title: "Hohe Priorität",
                    content: "Geben Sie hier einen relativen Anteil für Datenverkehr hoher Priorität an."
                }, {
                    type: "name",
                    title: "Mittlere Priorität",
                    content: "Geben Sie hier einen relativen Anteil für Datenverkehr mittlerer Priorität an."
                }, {
                    type: "name",
                    title: "Niedrige Priorität",
                    content: "Geben Sie hier einen relativen Anteil für Datenverkehr niedriger Priorität an."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Die Summe aller Prioritäten muss 1 sein."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Speichern, um Ihre Einstellungen zu übernehmen."
                }
            ]
        },
        QOS_RULE: {
            TITLE: "QoS-Regelliste",
            CONTENT: [
                {
                    type: "name",
                    title: "Typ",
                    content: "Wählen Sie einen Typ aus, den Sie zur QoS-Regelliste hinzufügen möchten."
                }, {
                    type: "step",
                    title: "So richten Sie eine gerätebezogene Regel für hohe/mittlere/niedrige Priorität ein:",
                    content: ["1. Klicken Sie Hinzufügen.", "2. Wählen Sie Gerätebezogen.", "3. Klicken Sie Existierende Geräte anzeigen, um Ihr Gerät aus der Liste der Zugriffsgeräte aus oder geben Sie ein Kombination aus Gerätenamen und MAC-Adresse von Hand ein.", "4. Klicken Sie OK."]
                }, {
                    type: "step",
                    title: "So richten Sie eine anwendungsbezogene Regel für hohe/mittlere/niedrige Priorität ein:",
                    content: ["1. Klicken Sie Hinzufügen.", "2. Wählen Sie Anwendungsbezogen.", "3. Wählen Sie aus der Liste der Applikationen die gewünschte aus oder konfigurieren Sie Namen, Protokoll und Portnummer von Hand.", "4. Klicken Sie OK."]
                }, {
                    type: "step",
                    title: "So richten Sie eine portbezogene Regel für hohe/mittlere/niedrige Priorität ein:",
                    content: ["1. Klicken Sie Hinzufügen.", "2. Wählen Sie Portbezogen.", "3. Wählen Sie den gewünschten Port aus.", "4. Klicken Sie OK."]
                }
            ]
        },
        QOS_DATABASE: {
            TITLE: "Datenbank-Upgrade",
            CONTENT: [
                {
                    type: "name",
                    title: "Datei mit der neuen Datenbank",
                    content: "Klicken Sie Durchsuchen, um die Datei auszuwählen. Klicken Sie Upgraden, um den Vorgang zu starten."
                }, {
                    type: "name",
                    title: "Datenbankversion",
                    content: "Zeigt die aktuell installierte Version der Datenbank an."
                }
            ]
        },
        SECURITY_FIREWALL: {
            TITLE: "Firewall",
            CONTENT: [
                {
                    type: "name",
                    title: "SPI-Firewall",
                    content: "Die SPI-Firewall verhindert bestimmte Angriffe, indem Sie den Inhalt der eingehenden Pakete untersucht. Die SPI-Firewall ist standardmäßig aktiviert."
                }
            ]
        },
        SECURITY_DOS: {
            TITLE: "DoS-Schutz",
            CONTENT: [
                {
                    type: "name",
                    title: "DoS-Schutz",
                    content: "Der DoS(Denial of Service)-Schutz schützt Ihr lokales Netz gegen DoS-Angriffe. Standardmäßig ist der DoS-Schutz deaktiviert (Aus)."
                }, {
                    type: "name",
                    title: "Filterung vor ICMP-FLOOD-Angriffen",
                    content: "Schützt vor Angriffen über das Internet Control Message Protocol (ICMP)."
                }, {
                    type: "name",
                    title: "Filterung von UDP-FLOOD-Angriffen",
                    content: "Schützt vor Angriffen über das User Datagram Protocol (UDP)."
                }, {
                    type: "name",
                    title: "Filterung von TCP-SYN-FLOOD-Angriffen",
                    content: "Schützt vor Angriffen über Transmission Control Protocol-Synchronize (TCP-SYN).",
                    children: [
                        {
                            type: "name",
                            title: "Aus",
                            content: "Kein Schutz."
                        }, {
                            type: "name",
                            title: "Niedrig",
                            content: "Geringer Schutz, geringer Einfluss auf die Router-Performance."
                        }, {
                            type: "name",
                            title: "Mittel",
                            content: "Moderater Schutz, eventuell merklicher Einfluss auf die Router-Performance."
                        }, {
                            type: "name",
                            title: "Hoch",
                            content: "Hoher Schutz, deutlicher Einfluss auf die Router-Performance."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ping-Pakete auf den WAN-Port ignorieren",
                    content: "Beantwortet Echo-Anfragen auf den WAN-Port nicht."
                }, {
                    type: "name",
                    title: "Ping-Pakete von LAN-Seite ignorieren",
                    content: "Beantwortet Echo-Anfragen auf die LAN-Ports nicht."
                }
            ]
        },
        MAC_FILTER_ALL: {
            TITLE: "MAC-Adressfilter",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "MAC-Adressfilterung wird verwendet, um bestimmte Geräte von der Netznutzung auszuschließen. Ein blockiertes Gerät hat keinen Zugriff auf das WLAN Ihres Powerlinegerätes."
                }, {
                    type: "name",
                    title: "MAC-Adressfiltereinstellungen",
                    children: [
                        {
                            type: "name",
                            title: "MAC-Adressfilter",
                            content: "<b>Aktivieren</b> Sie diese Funktion, um sie zu nutzen. Ist sie deaktiviert (Aus), können alle Geräte sich verbinden."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Filterregel auswählen",
                    content: "Wählen Sie aus, ob Sie in der Geräteliste aufgeführte Clientgeräte blockieren oder zulassen wollen. Klicken Sie <b>Speichern</b>, um Ihre Einstellungen zu speichern."
                }, {
                    type: "name",
                    title: "Geräteliste",
                    children: [
                        {
                            type: "step",
                            title: "Hinzufügen eines Clientgeräts"
                        }, {
                            type: "step",
                            title: "Bearbeiten oder Löschen eines Clientgeräts",
                            content: "Klicken Sie für das zu bearbeitende/löschende Gerät <b>Bearbeiten</b> oder die <b>Mülltonne</b>."
                        }, {
                            type: "step",
                            title: "Löschen mehrerer Geräte in the Geräteliste",
                            content: "Wählen Sie die zu löschenden Geräte an und klicken Sie oberhalb der Tabelle <b>Löschen</b>."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER: {
            TITLE: "MAC-Adressfilter",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "MAC-Adressfilterung wird verwendet, um bestimmte Geräte von der Netznutzung auszuschließen. Ein blockiertes Gerät hat keinen Zugriff auf das WLAN Ihres Powerlinegerätes."
                }, {
                    type: "name",
                    title: "MAC-Adressfiltereinstellungen",
                    children: [
                        {
                            type: "name",
                            title: "MAC-Adressfilter",
                            content: "<b>Aktivieren</b> Sie diese Funktion, um sie zu nutzen. Ist sie deaktiviert (Aus), können alle Geräte sich verbinden."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER_RULES: {
            TITLE: "Filterregel wählen",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wählen Sie aus, ob Sie in der Geräteliste aufgeführte Clientgeräte blockieren oder zulassen wollen."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Speichern</b>, um Ihre Einstellungen zu speichern."
                }
            ]
        },
        MAC_FILTER_DEVICE_LIST: {
            TITLE: "Geräteliste",
            CONTENT: [
                {
                    type: "step",
                    title: "Hinzufügen eines Clientgeräts",
                    content: ["1. Klicken Sie <b>Hinzufügen</b>.", "2. Klicken Sie <b>Geräte anzeigen</b> und wählen Sie die MAC-Adresse des Gerätes aus der Liste aus oder geben Sie die MAC-Adresse von Hand ein.", "3. Vergeben Sie für das Gerät eine kurze Beschreibung.", "4. Wählen Sie <b>Eintrag aktivieren.</b>", "5. Klicken Sie <b>OK</b>."]
                }, {
                    type: "step",
                    title: "Bearbeiten eines Gerätes in der Geräteliste",
                    content: "Klicken Sie für das zu bearbeitende/löschende Gerät <b>Bearbeiten</b> oder die <b>Mülltonne</b>."
                }, {
                    type: "step",
                    title: "Löschen mehrerer Geräte in der Geräteliste",
                    content: "Wählen Sie die zu löschenden Geräte an und klicken Sie oberhalb der Tabelle <b>Löschen</b>."
                }
            ]
        },
        WIFI_MOVE: {
            TITLE: "WiFi-Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Ist WiFi-Move aktiviert, werden alle Änderungen an den WLAN-Einstellungen eines Powerlineadapters automatisch mit den anderen Powerlineadaptern im selben Powerlinenetz synchronisiert, sofern auf diesen ebenfalls WiFi-Move aktiviert ist. Ändern Sie den Namen, wird WiFi-Move automatisch deaktiviert."
                }, {
                    type: "name",
                    title: "WiFi-Move",
                    content: "<b>Aktivieren</b> Sie diese Funktion, um sie zu nutzen."
                }
            ]
        },
        SECURITY_LIST: {
            TITLE: "Liste blockierter DoS-Hosts",
            CONTENT: [
                {
                    type: "name",
                    title: "Liste blockierter DoS-Hosts",
                    content: "Liste der IP- und MAC-Adressen, die aufgrund von DoS-Angriffen negativ aufgefallen sind und blockiert wurden."
                }, {
                    type: "step",
                    title: "Löschen eines Eintrags",
                    content: "Wählen Sie in der Hostliste den zu löschenden Eintrag aus und klicken Sie oberhalb der Tabelle Löschen."
                }
            ]
        },
        ACCESS_CONTROL: {
            TITLE: "Zugriffskontrolle",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Die Zugriffskontrolle steuert den Zugriff bestimmter Geräte in Ihrem Netz. Ein blockiertes Gerät kann zwar eine IP-Adresse vom DHCP-Server bekommen, doch nicht auf das Netz zugreifen."
                }, {
                    type: "paragraph",
                    content: "Um die Kindersicherung zu benutzen, aktivieren Sie diese und geben Sie an, ob Sie mittels Blacklist oder Whitelist filtern möchten. Ist die Kindersicherung deaktiviert, können alle gelisteten Geräte, egal ob Blacklist oder Whitelist, das Netz benutzen."
                }
            ]
        },
        ACCESS_MODE: {
            TITLE: "Zugriffsmodus",
            CONTENT: [
                {
                    type: "name",
                    title: "Blacklist",
                    content: "Bis auf die gelisteten Geräte können alle Geräte das Netz nutzen."
                }, {
                    type: "name",
                    title: "Whitelist",
                    content: "Nur die Geräte, die sich in der Whitelist befinden, können das Netz benutzen."
                }
            ]
        },
        ACCESS_DEVICE: {
            TITLE: "Geräte online",
            CONTENT: [
                {
                    type: "name",
                    title: "Gerätename",
                    content: "Name des verbundenen Gerätes."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "IP-Adresse des verbundenen Gerätes."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "MAC-Adresse des verbundenen Gerätes."
                }, {
                    type: "name",
                    title: "Verbindungstyp",
                    content: "Verbindungstyp des verbundenen Gerätes."
                }, {
                    type: "step",
                    title: "Blockieren eines Gerätes",
                    content: "In der Tabelle Geräte online klicken Sie in der richtigen Zeile auf Blockieren in der Spalte Bearbeiten."
                }, {
                    type: "step",
                    title: "Blockieren mehrerer Geräte",
                    content: "Wählen Sie in der Tabelle Geräte online alle zu blockierenden Geräte aus und klicken Sie über der Tabelle Blockieren. Diese Geräte werden dann zur Black- bzw. Whitelist hinzugefügt."
                }
            ]
        },
        ACCESS_LIST: {
            TITLE: "Geräte in der Black-/Whitelist",
            CONTENT: [
                {
                    type: "step",
                    title: "So blacklisten/whitelisten Sie ein Gerät:",
                    content: ["1. Klicken Sie Hinzufügen.", "2. Geben Sie den Gerätenamen ein.", "3. Geben Sie die MAC-Adresse des Gerätes ein.", "4. Klicken Sie OK."]
                }, {
                    type: "step",
                    title: "So bearbeiten oder entfernen Sie ein gelistetes Gerät:",
                    content: "In der Tabelle Blacklist bzw. Whitelist klicken Sie für das entsprechende Gerät Bearbeiten oder Löschen."
                }, {
                    type: "step",
                    title: "Löschen mehrerer Geräte",
                    content: "Wählen Sie in der Tabelle Blacklist/Whitelist alle zu löschenden Geräte aus und klicken Sie über der Tabelle Löschen."
                }
            ]
        },
        IPMAC_BIND_SETTING: {
            TITLE: "Einstellungen",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Eine ARP(Address Resolution Protocol)-Bindung ist hilfreich bei der Zugriffskontrolle eines bestimmten Computers, wenn Sie dessen IP- und MAC-Adresse fest miteinander assoziieren wollen. ARP-Binding verhindert, dass andere Geräte die angegebene IP-Adresse benutzen."
                }
            ]
        },
        IPMAC_BIND_ARP: {
            TITLE: "ARP-Liste",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Zeigt die MAC- und IP-Adressen der aktuell angeschlossenen Geräte an."
                }, {
                    type: "name",
                    title: "Anzahl ARP-Einträge",
                    content: "Die Gesamtanzahl der aktuell mit dem Router verbundenen Geräte."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "MAC-Adresse des verbundenen Gerätes."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Die IP-Adresse, die dem Gerät zugewiesen ist."
                }, {
                    type: "name",
                    title: "Gebunden",
                    content: "Zeigt an, ob die Kombination aus MAC- und IP -Adresse gebunden ist."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Hier finden Sie Optionen, um eine Kombination zu Binden oder zu Löschen."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Ein und die selbe IP-Adresse kann nicht gleichzeitig mehreren MAC-Adressen zugeordnet sein."
                }
            ]
        },
        IPMAC_BIND_LIST: {
            TITLE: "Bindungsliste",
            CONTENT: [
                {
                    type: "step",
                    title: "So richten Sie eine ARP-Bindung ein:",
                    content: [
                        "1. Klicken Sie Hinzufügen.",
                        "2. Geben Sie die MAC-Adresse des Gerätes ein.",
                        "3. Geben Sie eine mit diesem Gerät zu assoziierende IP-Adresse ein.",
                        "4. Vergeben Sie eine Beschreibung für das Gerät (optional).",
                        "5. Wählen Sie Aktivieren.",
                        "6. Klicken Sie OK."
                    ]
                }, {
                    type: "step",
                    title: "So bearbeiten oder löschen Sie einen Eintrag:",
                    content: "Klicken Sie in der Liste der Bindungen für den entsprechenden Eintrag Bearbeiten oder Löschen."
                }, {
                    type: "step",
                    title: "Löschen mehrerer Einträge:",
                    content: "Wählen Sie in der Bindungsliste die zu löschenden Einträge an und klicken Sie oberhalb der Liste Löschen."
                }
            ]
        },
        IPV6: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "Aktivieren oder Deaktivieren der IPv6-Unterstützung durch den Router."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: Statische IP-Adresse"
                }, {
                    type: "name",
                    title: "Statische IP-Adresse",
                    content: "Wählen Sie dies aus, wenn Ihr Internetdiensteanbieter statische IPv6-Konfigurationen bereitstellt."
                }, {
                    type: "name",
                    title: "IPv6-Adresse/Standardgateway/Haupt-DNS-Server/Backup-DNS-Server",
                    content: "Geben Sie hier die Informationen ein, die Ihnen Ihr Internetdiensteanbieter gegeben hat."
                }, {
                    type: "name",
                    title: "MTU-Größe",
                    content: "Ein typischer Wert für die MTU(Maximum Transmission Unit)-Größe von Ethernet-Anwendungen ist 1500 Byte. Wir empfehlen, diese nicht zu ändern, es sei denn, Sie wurden angewiesen, dies zu tun."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: Dynamische IP-Adresse"
                }, {
                    type: "name",
                    title: "Dynamische IP-Adresse",
                    content: "Wählen Sie dies aus, wenn Ihr Internetdiensteanbieter dynamische IPv6-Konfigurationen bereitstellt."
                }, {
                    type: "name",
                    title: "IPv6-Adresse/Haupt-DNS-Server/Backup-DNS-Server",
                    content: "Diese Informationen werden vom DHCPv6-Server Ihres Internetdiensteanbieters automatisch gesetzt."
                }, {
                    type: "name",
                    title: "Erneuern",
                    content: "Klicken Sie hier, um Ihre IP-Konfiguration zu erneuern."
                }, {
                    type: "name",
                    title: "Freigeben",
                    content: "Klicken Sie hier, um Ihre aktuelle IP-Konfiguration zurückzugeben."
                }, {
                    type: "name",
                    title: "Abruf meiner IPv6-Adresse",
                    content: "Wählen Sie “Nicht-temporäre IPv6-Adresse beziehen” oder “IPv6-Präfixdelegation beziehen”, gemäß den Vorgaben Ihres Internetdiensteanbieters."
                }, {
                    type: "name",
                    title: "DNS-Serveradresse",
                    content: "Wähnen Sie “Dynamisch vom Internetdiensteanbieter beziehen” oder “Folgende DNS-Serveradresse benutzen”. Haben Sie “Folgende DNS-Serveradresse benutzen” gewählt, geben Sie bitte die von Ihrem Internetdiensteanbieter angegebene DNS-Serveradresse von Hand ein."
                }, {
                    type: "name",
                    title: "Haupt-DNS-Server/Backup-DNS-Server",
                    content: "Geben Sie diese Parameter von Hand ein oder lassen Sie den Router sie automatisch von Ihrem Anbieter abrufen."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "Wählen Sie diesen Typ, falls Ihr Internetdiensteanbieter PPPoEv6 verwendet und Ihnen hierfür Benutzernamen und Passwort mitgeteilt hat."
                }, {
                    type: "name",
                    title: "Benutzername/Passwort",
                    content: "Geben Sie hier die Anmeldeinformationen von Ihrem Internetdiensteanbieter ein. Hierbei wird zwischen Groß- und Kleinschreibung unterschieden."
                }, {
                    type: "name",
                    title: "IPv6-Adresse",
                    content: "Diese wird vom DHCPv6-Server Ihres Internetdiensteanbieters automatisch zugewiesen, nachdem Sie Benutzernamen und Passwort eingegeben und Verbinden geklickt haben."
                }, {
                    type: "name",
                    title: "DNS-Serveradresse",
                    content: "Wähnen Sie “Dynamisch vom Internetdiensteanbieter beziehen” oder “Folgende DNS-Serveradresse benutzen”. Haben Sie “Folgende DNS-Serveradresse benutzen” gewählt, geben Sie bitte die von Ihrem Internetdiensteanbieter angegebene DNS-Serveradresse von Hand ein."
                }, {
                    type: "name",
                    title: "Abruf meiner IPv6-Adresse",
                    content: "Wählen Sie “Nicht-temporär”, “Präfix-Delegation” oder “Vom Internetdiensteanbieter vorgegeben” gemäß den Vorgaben Ihres Internetdiensteanbieters. Haben Sie “Vom Internetdiensteanbieter vorgegeben” gewählt, müssen Sie Ihre IPv6-Adresse von Hand eingeben. Haben Sie “Nicht-temporär” oder “Präfix-Delegation” gewählt, wird die IPv6-Adresse vom DHCPv6-Server Ihres Internetdiensteanbieters automatisch zugewiesen.",
                    children: [
                        {
                            type: "name",
                            title: "Nicht-temporär",
                            content: "Eine nicht-temporäre IPv6-Adresse vom DHCPv6-Server Ihres Internetdiensteanbieter abrufen."
                        }, {
                            type: "name",
                            title: "Präfix-Delegation",
                            content: "Abrufen einer Präfix-Delegations-IPv6-Adresse vom DHCPv6-Server Ihres Internetdiensteanbieters. Die Geräte in Ihrem Netz erstellen mittels der Delegation ihre IPv6-Adressen."
                        }, {
                            type: "name",
                            title: "Vom Internetdiensteanbieter vorgegeben",
                            content: "Von Ihrem Internetdiensteanbieter vorgegebene statische IPv6-Adresse verwenden."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Verbinden",
                    content: "Klicken, um eine Internetverbindung herzustellen."
                }, {
                    type: "name",
                    title: "Trennen",
                    content: "Trennen der Internetverbindung."
                }, {
                    type: "title",
                    title: "Internetverbindungytyp: 6to4-Tunnel"
                }, {
                    type: "name",
                    title: "6to4-Tunnel",
                    content: "Wählen Sie dies aus, wenn Ihr Internetdiensteanbeter für die Adresszuweisung 6to4-Deployment verwendet."
                }, {
                    type: "name",
                    title: "IPv4-Adresse/IPv4-Subnetzmaske/IPv4-Standardgateway/Tunneladresse",
                    content: "Diese Parameter werden dynamisch mittels der IPv4-Parameter des WAN-Ports generiert, nachdem Sie Verbinden geklickt haben."
                }, {
                    type: "name",
                    title: "Folgende DNS-Serveradressen benutzen",
                    content: "Die von Ihnen hier eingegebene(n) DNS-Serveradresse(n) verwenden."
                }, {
                    type: "name",
                    title: "Verbinden",
                    content: "Klicken, um eine Internetverbindung herzustellen."
                }, {
                    type: "name",
                    title: "Trennen",
                    content: "Trennen der Internetverbindung."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: 6RD"
                }, {
                    type: "name",
                    title: "6RD",
                    content: "Wählen Sie diesen Typ, falls Ihr Internetdiensteanbieter 6RD-Deployment verwendet und Ihnen sowohl eine IPv4-Adresse als auch ein IPv6-Adressenpräfix bereitgestellt hat."
                }, {
                    type: "name",
                    title: "Konfigurationstyp",
                    content: "Wählen Sie zur Konfiguration der 6RD-Channelparameter Automatisch oder Manuell, gemäß den Vorgaben Ihres Internetdiensteanbieters. Kollidieren die untenstehenden Standardparameter mit denen, die Ihr Internetdiensteanbieter vorgibt, wählen Sie Automatisch. Ansonsten wählen Sie Manuell und geben die Parameter ein, wie von Ihrem Internetdiensteanbieter vorgegeben."
                }, {
                    type: "name",
                    title: "IPv4-Maskenlänge/6RD-Präfix/6RD-Präfixlänge/Border-Reply-IPv4-Adresse",
                    content: "Überprüfen Sie, ob die voreingestellten Parameter mit denen, die Ihr Internetdiensteanbieter vorgibt und behalten Sie die Standardwerte oder geben Sie sie ein, wie von Ihrem Internetdiensteanbieter vorgegeben."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "Wählen Sie diesen Typ, falls Ihr Internetdiensteanbieter DS-Lite-Deployment verwendet und Ihnen einen AFTR-Domänennamen oder eine IPv6-Adresse zur Einrichtung eines IPv4-in-IPv6-Tunnels gegeben hat, um in einem IPv6-Netz IPv4-Datenverkehr zu transportieren oder IPv6-Datenverkehr im eigenen Netz."
                }, {
                    type: "name",
                    title: "AFTR-Name",
                    content: "Geben Sie hier den AFTR(Address Family Transition Router)-Domänennamen oder die IPv6-Adresse ein, wie von Ihrem Internetdiensteanbieter vorgegeben."
                }, {
                    type: "name",
                    title: "Zweitverbindung",
                    content: "Typ der Zweitverbindung, wie von Ihrem Internetdiensteanbieter vorgegeben.",
                    children: [
                        {
                            type: "name",
                            title: "Dynamische IP-Adresse",
                            content: "Wählen Sie dies, falls Ihr Internetdiensteanbieter Ihnen eine dynamische IP-Adresse für die Zweitverbindung gegeben hat und die Parameter IPv6-Adresse/Haupt-DNS-Server/Backup-DNS-Server automatisch vom DHCPv6-Server Ihres Internetdiensteanbieters zugewiesen werden."
                        }, {
                            type: "name",
                            title: "Statische IP-Adresse",
                            content: "Wählen Sie dies aus, wenn Ihr Internetdiensteanbieter statische IPv6-Konfigurationen bereitstellt."
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "Wählen Sie dies, falls Ihr Internetdiensteanbieter Ihnen eine PPPoE-Verbindung als Zweitverbindung gegeben hat und geben Sie dann Benutzernamen und Passwort ein, wie von Ihrem Internetdiensteanbieter vorgegeben. Die IPv6-Adresse wird automatisch zugewiesen, wenn Sie Verbinden geklickt haben."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: Passthrough (Bridge)"
                }, {
                    type: "paragraph",
                    content: "Wählen Sie diesen Typ, falls Ihr Internetdiensteanbieter Passthrough(Bridge)-Netzdeployment verwendet. Für diesen Typ sind keinerlei Parameter oder Konfiguration erforderlich."
                }
            ]
        },
        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Außer beim WAN-Verbindungstyp Passthrough (Bridge) müssen folgende IPv4-LAN-Einstellungen getätigt werden:"
                }, {
                    type: "name",
                    title: "Zugewiesener Typ",
                    content: "Wählen Sie hier den von Ihrem Internetdiensteanbieter vorgegebenen Typ aus.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "Weist Geräten im lokalen Netz automatisch IP-Adressen zu.",
                            children: [
                                {
                                    type: "name",
                                    title: "Adressenpräfix",
                                    content: "Geben Sie hier das von Ihrem Internetdiensteanbieter vorgegebene Präfix an."
                                }, {
                                    type: "name",
                                    title: "Adresshaltezeit",
                                    content: "Die Zeitdauer, die die IP-Adresse gültig bleibt. Behalten Sie den Standardwert 86400 Sekunden oder ändern Sie den Wert, falls Ihr Internetdiensteanbieter Ihnen dies vorschreibt."
                                }, {
                                    type: "name",
                                    title: "Adresse",
                                    content: "Die vom Internetdiensteanbieter automatisch zugewiesene IPv6-Adresse."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC + Zustandsloses DHCP",
                            children: [
                                {
                                    type: "name",
                                    title: "Adressenpräfix",
                                    content: "Geben Sie hier das von Ihrem Internetdiensteanbieter vorgegebene Präfix an."
                                }, {
                                    type: "name",
                                    title: "Adresse",
                                    content: "Die vom Internetdiensteanbieter automatisch zugewiesene IPv6-Adresse."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC + RDNSS",
                            children: [
                                {
                                    type: "name",
                                    title: "Adressenpräfix",
                                    content: "Geben Sie hier das von Ihrem Internetdiensteanbieter vorgegebene Präfix an."
                                }, {
                                    type: "name",
                                    title: "Adresse",
                                    content: "Die vom Internetdiensteanbieter automatisch zugewiesene IPv6-Adresse."
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        IPV6_MAC_CLONE: {
            TITLE: "MAC-Adresse klonen",
            CONTENT: [
                {
                    type: "name",
                    title: "Standard-MAC-Adresse benutzen",
                    content: "Standard-MAC-Adresse des Routers wiederherstellen."
                }, {
                    type: "name",
                    title: "MAC-Adresse des Computers verwenden",
                    content: "Hiermit kopieren Sie die MAC-Adresse Ihres Computers. Sinnvoll, wenn Ihr Computer bisher direkt an das Internet angeschlossen war (ohne Router) und Ihr Internetdiensteanbieter sich diese MAC-Adresse gemerkt hat."
                }, {
                    type: "name",
                    title: "Benutzerdefinierte MAC-Adresse",
                    content: "Geben Sie die gewünschte MAC-Adresse von Hand ein."
                }
            ]
        },
        TIME_SETTING: {
            TITLE: "Uhrzeiteinstellungen",
            CONTENT: [
                {
                    type: "step",
                    title: "So lassen Sie die Routerzeit automatisch einstellen:",
                    content: ["1. Wählen Sie Ihre <b>Zeitzone</b> aus der Drop-Down-Liste.", "2. Geben Sie in das Feld <b>NTP-Server I</b> die IP-Adresse eines NTP-Servers ein (optional).", "3. Geben Sie in das Feld <b>NTP-Server II</b> die IP-Adresse eines zweiten NTP-Servers ein (optional).", "4. Klicken Sie <b>GMT abrufen</b>."]
                }, {
                    type: "step",
                    title: "So setzen Sie die Routerzeit von Hand:",
                    content: ["1. Wählen Sie im Feld <b>Uhrzeiteinstellungen</b> Ihre <b>Zeitzone</b> aus.", "2. Geben Sie das aktuelle <b>Datum</b> ein.", "3. Wählen Sie die aktuelle <b>Uhrzeit</b> (im 24-Stunden-Format, z.B. bedeutet 16:00:00 4 Uhr nachmittags).", "4. Klicken Sie <b>Speichern</b>."]
                }
            ]
        },
        TIME_SETTING_DAYLIGHT: {
            TITLE: "Sommerzeit",
            CONTENT: [
                {
                    type: "step",
                    title: "So konfigurieren Sie die Sommerzeit:",
                    content: ["1. Wählen Sie <b>Sommerzeit aktivieren</b>.", "2. Wählen Sie als <b>Start</b>datum und -Uhrzeit den Zeitpunkt, zu dem die Sommerzeit beginnt.", "3. Wählen Sie als <b>End</b>datum und -Uhrzeit den Zeitpunkt, zu dem die Sommerzeit endet.", "4. Klicken Sie <b>Speichern</b>."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "Diagnose",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Ihr Router verfügt über ein Ping- und ein Traceroute-Diagnosetool zur Erkennung von Verbindungsproblemen. Das Ping-Tool schickt Pakete an das angegebene Ziel und wertet die Antwortpakete aus hinsichtlich Erfolgsquote und Antwortzeit. Das Traceroute-Tool schickt Pakete an das angegebene Ziel und zeigt IP-Adresse und Antwortzeit der Zwischenschritte an."
                }, {
                    type: "paragraph",
                    content: "Ziele von Ping und Traceroute können mittels IP-Adresse oder Domänenname angegeben werden."
                }, {
                    type: "step",
                    title: "Diagnose mittels Ping",
                    content: ["1. Geben Sie IP-Adresse oder Hostnamen des Ziels ein.", "2. (optional) Klicken Sie auf den Pfeil, um das Erweiterte Menü zu öffnen und Anzahl und Größe der Ping-Pakete zu bestimmen.", "3. Klicken Sie Start."]
                }, {
                    type: "step",
                    title: "Diagnose mittels Traceroute",
                    content: ["1. Geben Sie IP-Adresse oder Hostnamen des Ziels ein.", "2. (optional) Klicken Sie auf den Pfeil, um das Erweiterte Menü zu öffnen und die maximale Anzahl Hops (to be reached) in das Feld Traceroute-TTL (Time to Live) ein. Standardwert: 20.", "3. Klicken Sie Start."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "Firmware-Upgrade",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Bevor Sie die Firmware Ihres Powerlineadapters aktualisieren, müssen Sie die neueste Firmware von <a class=\"link\" href=\"http://www.tp-link.com.de/Support\" target=\"_blank\">TP-Links Supportseite</a> auf Ihren Computer herunterladen."
                }, {
                    type: "step",
                    title: "WICHTIG! Um Schäden beim Upgrade zu vermeiden, beachten Sie:",
                    content: ["Die Firmwaredatei muss zur Hardwareversion Ihres Routers passen (auf der Downloadseite angegeben).", "Stellen Sie sicher, dass Ihre Verbindung zum Powerlineadapter stabil ist. Es wird NICHT empfohlen, die Firmware über eine WLAN-Verbindung zu tätigen.", "Sichern Sie die Konfiguration Ihres Powerlineadapters.", "Schalten Sie Ihren Powerlineadapter während des Firmware-Upgrades NICHT ab."]
                }, {
                    type: "step",
                    title: "Aktualisieren der Firmware Ihres Powerlinegeräts",
                    content: ["1. Klicken Sie <b>Durchsuchen</b>.", "2. Wählen Sie die Firmwaredatei aus.", "3. Klicken Sie <b>Upgrade</b>."]
                }, {
                    type: "paragraph",
                    content: "Das Upgrade dauert einige Minuten. Schalten Sie Ihren Powerlineadapter in dieser Zeit bitte NICHT ab."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "Onlineupgrade der Firmware",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["Klicken Sie Aktualisieren und dann Ja, lädt das Gerät automatisch die neueste Firmware herunter und installiert sie. Sie können auch Nach Aktualisierungen suchen klicken, um zu sehen, ob eine neue Firmware verfügbar ist."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "Manuelles Firmware-Upgrade",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. Klicken Sie unten auf der Seite auf Support und laden Sie sich die neueste Firmware herunter. Bitte stellen Sie sicher, dass die Firmware für die Hardwareversion Ihres Routers freigegeben ist.", "2. Klicken Sie Durchsuchen and wählen Sie die heruntergeladene Firmwaredatei aus.", "3. Klicken Sie Upgrade."]
                }, {
                    type: "paragraph",
                    content: ["Das Firmware-Upgrade wird einige Minuten dauern. Anschließend startet der Router automatisch neu."]
                }
            ]
        },
        BACKUP: {
            TITLE: "Backup",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Es wird empfohlen, Ihre aktuelle Konfiguration zu sichern für den Fall, dass Sie sie wiederherstellen müssen."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Sichern</b>, um Ihre aktuelle Konfiguration in einer Datei auf Ihrem Computer zu speichern. Bewahren Sie diese an einem sicheren Ort auf."
                }
            ]
        },
        RESTORE: {
            TITLE: "Wiederherstellen",
            CONTENT: [
                {
                    type: "step",
                    title: "So stellen Sie eine gesicherte Routerkonfiguration wieder her:",
                    content: ["1. Klicken Sie <b>Durchsuchen</b>.", "2. Wählen Sie die Konfigurationsdatei aus.", "3. Klicken Sie <b>Wiederherstellen</b>."]
                }
            ]
        },
        FACTORY: {
            TITLE: "Werkseinstellungen wiederherstellen",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Klicken Sie <b>Gerät zurücksetzen</b>, um Ihren Powerlineadapter auf Standardeinstellungen zurückzusetzen."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: ["1. Alle von Ihnen getätigten Einstellungen gehen prinzipbedingt verloren, wenn Sie die Standardwerte wiederherstellen. Um sich danach erneut einzuloggen, verwenden Sie Standard-Benutzernamen und -Passwort <b>admin</b>.", "2. Bitte schalten Sie das Gerät während des Wiederherstellens nicht aus."]
                }
            ]
        },
        ADMIN_ACCOUNT: {
            TITLE: "Kontenverwaltung",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Diese Seite erlaubt Ihnen das Ändern Ihres Benutzernamens und/oder Ihres Passworts."
                }, {
                    type: "name",
                    title: "Alter Benutzername",
                    content: "Geben Sie hier den aktuell gültigen Benutzernamen ein."
                }, {
                    type: "name",
                    title: "Altes Passwort",
                    content: "Geben Sie hier das aktuell gültige Passwort ein."
                }, {
                    type: "name",
                    title: "Neuer Benutzername",
                    content: "Geben Sie hier den neuen Benutzernamen ein."
                }, {
                    type: "name",
                    title: "Neues Passwort",
                    content: "Geben Sie hier das neue Passwort ein."
                }, {
                    type: "name",
                    title: "Neues Passwort bestätigen",
                    content: "Geben Sie hier erneut das neue Passwort ein."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Ändern Sie Benutzernamen oder Passwort, stellen Sie bitte sicher, dass Sie diese Informationen nicht verlieren. Ein starkes Passwort sollte aus mindestens 8 Zeichen bestehen und Klein- und Großbuchstaben, Ziffern und Sonderzeichen beinhalten."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie <b>Speichern</b> , um all Ihre Einstellungen zu speichern."
                }
            ]
        },
        ADMIN_RECOVERY: {
            TITLE: "Passwortwiederherstellung",
            CONTENT: [
                {
                    type: "name",
                    title: "Passwortwiederherstellung aktivieren",
                    content: "Aktivieren der Funktion, damit Sie sich Ihr vergessenes Passwort per E-Mail zuschicken lassen können (empfohlen)."
                }, {
                    type: "name",
                    title: "Von",
                    content: "Geben Sie hier eine gültige Absender-E-Mail-Adresse ein."
                }, {
                    type: "name",
                    title: "An",
                    content: "Geben Sie hier die E-Mail-Adresse ein, an die Sie Ihr Passwort verschicken lassen möchten."
                }, {
                    type: "name",
                    title: "SMTP-Server",
                    content: "Geben Sie hier die SMTP-Serveradresse ein, mit der der Router Ihr Passwort verschicken kann."
                }, {
                    type: "name",
                    title: "Authentifizierung aktivieren",
                    content: "Wählen Sie dies aus, wenn Ihr SMTP-Server zum E-Mail-Schicken eine Authentifizierung verlangt (sehr gebräuchlich). Geben Sie hierzu Benutzernamen und Passwort ein. Achten Sie auf Groß- und Kleinschreibung."
                }
            ]
        },
        ADMIN_LOCAL: {
            TITLE: "Lokale Verwaltung",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "In diesem Abschnitt können Sie die Anzahl der Clientgeräte in Ihrem lokalen Netz, die auf Ihr Gerät zugreifen können, mit Hilfe der MAC-Adress-basierenden Authentifizierung einschränken."
                }, {
                    type: "name",
                    title: "Zugriff für alle lokalen Geräte erlauben",
                    content: "Allen Geräten im lokalen Netz Zugriff auf die Weboberfläche gewähren. Ist dies deaktiviert, müssen Sie mindestens ein Gerät zulassen, um sich nicht selbst auszusperren."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die MAC-Adresse des konfigurierten Gerätes."
                }, {
                    type: "name",
                    title: "Beschreibung",
                    content: "Eine Beschreibung des Gerätes."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Gibt an, ob das Gerät zugelassen oder gesperrt ist."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Hier haben Sie die Möglichkeit, Einträge zu Bearbeiten und zu Löschen."
                }, {
                    type: "step",
                    title: "So fügen Sie ein neues Gerät zur Liste hinzu:",
                    content: ["1. Klicken Sie Hinzufügen.", "2. Klicken Sie Existierende Geräte, um eines auszuwählen oder spezifizieren Sie das Gerät durch manuelle Eingabe der MAC-Adresse.", "3. Vergeben Sie eine Beschreibung. (Optional)", "4. Wählen Sie Aktivieren.", "5. Klicken Sie OK."]
                }, {
                    type: "step",
                    title: "So bearbeiten oder löschen Sie ein in der Liste befindliches Gerät:",
                    content: "Klicken Sie in der entsprechenden Zeile Bearbeiten oder Löschen."
                }, {
                    type: "step",
                    title: "Löschen mehrerer Geräte",
                    content: "Wählen Sie alle zu löschenden Geräte aus und klicken Sie dann auf Löschen."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "Fernwartung",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mit der Fernwartung können Sie auch über das Internet auf die Weboberfläche Ihres Routers zugreifen."
                }, {
                    type: "name",
                    title: "Fernwartung deaktivieren",
                    content: "Hiermit deaktivieren Sie die Fernwartung."
                }, {
                    type: "name",
                    title: "Fernwartung für alle Geräte zugänglich machen",
                    content: "Diese Option erlaubt die Fernwartung von allen IP-Adressen. Wenn aktiviert, muss auch das Feld Portnummer für Fernwartung ausgefüllt sein."
                }, {
                    type: "name",
                    title: "Fernwartung nur für angegebene Geräte zulassen",
                    content: "Diese Option erlaubt die Fernwartung nur von den angegebenen IP-Adressen. Wenn aktiviert, muss auch das Feld Portnummer für Fernwartung ausgefüllt sein."
                }, {
                    type: "name",
                    title: "Fernwartungsport",
                    content: "Geben Sie eine zu verwendende Portnummer von 1024 bis 65535 ein. Normalerweise verwenden Webserver den Standard-HTTP-Port 80. Der Standard-Dienstport für die Fernwartung dieses Geräts ist 8080, ein alternativer HTTP-Dienstport."
                }, {
                    type: "name",
                    title: "Für Fernwartung zugelassene IP-Adresse",
                    content: "Geben Sie hier eine gültige IP-Adresse oder einen IP-Adressbereich ein, für den/die der Zugriff auf den Router erlaubt sein soll. Der Wert 255.255.255.255 erlaubt allen IP-Adressen den Zugriff."
                }
            ]
        },
        SYSTEM_LOG: {
            TITLE: "Systemprotokoll",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Das Systemprotokoll zeigt eine Auflistung der letzten Systemaktivitäten. Sie können definieren, welche Einträge angezeigt werden sollen."
                }, {
                    type: "name",
                    title: "Typ",
                    content: "Angezeigten Typ der Einträge definieren."
                }, {
                    type: "name",
                    title: "Ebene",
                    content: "Angezeigte Wichtigkeit der Einträge definieren."
                }, {
                    type: "name",
                    title: "Neu laden",
                    content: "Protokollansicht neu laden."
                }, {
                    type: "name",
                    title: "Alle löschen",
                    content: "Protokoll löschen."
                }, {
                    type: "name",
                    title: "Protokoll speichern",
                    content: "Klicken Sie hier, um das Systemprotokoll als Datei auf Ihren Computer herunterzuladen."
                }
            ]
        },
        TRAFFIC_STATISTIC: {
            TITLE: "Trafficstatistiken",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Die Trafficstatistiken zeigen Ihnen eine Übersicht über den LAN-, WAN- und WLAN-Datenverkehr."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Ist NAT-Boost aktiviert, müssen die Trafficstatistiken deaktiviert sein."
                }, {
                    type: "name",
                    title: "Trafficstatistiken",
                    content: "Standardmäßig sind die Trafficstatistiken deaktiviert. Um die Statistiken anzeigen zu lassen, klicken Sie Ein."
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "Trafficstatistikliste",
            CONTENT: [
                {
                    type: "name",
                    title: "IP-/MAC-Adresse",
                    content: "Zeigt IP- und MAC-Adressen der verbundenen Geräte an."
                }, {
                    type: "name",
                    title: "Pakete insgesamt",
                    content: "Gesamtzahl der durch dieses Gerät übertragenen Pakete."
                }, {
                    type: "name",
                    title: "Byte insgesamt",
                    content: "Durch dieses Gerät übertragene Gesamtdatenmenge."
                }, {
                    type: "name",
                    title: "Pakete aktuell",
                    content: "Anzahl der im letzten Zeitintervall durch dieses Gerät übertragenen Pakete."
                }, {
                    type: "name",
                    title: "Byte aktuell",
                    content: "Im letzten Zeitintervall durch dieses Gerät übertragene Datenmenge."
                }, {
                    type: "name",
                    title: "Aktuell gesendete ICMPs",
                    content: "Aktuell und maximal pro Sekunde durch den WAN-Port übertragene ICMP-Pakete."
                }, {
                    type: "name",
                    title: "Aktuell gesendete UDPs",
                    content: "Aktuell und maximal pro Sekunde durch den WAN-Port übertragene UDP-Pakete."
                }, {
                    type: "name",
                    title: "Aktuell gesendete SYNs",
                    content: "Aktuell und maximal pro Sekunde durch den WAN-Port übertragene SYN-Pakete."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Optionen zum Rücksetzen (auf null) und Löschen der Statistikdaten zu diesem Gerät."
                }, {
                    type: "name",
                    title: "Neu laden",
                    content: "Statistikenseite neu laden."
                }, {
                    type: "name",
                    title: "Alle rücksetzen",
                    content: "Alle Statistikdaten auf null setzen."
                }, {
                    type: "name",
                    title: "Alle löschen",
                    content: "Alle Statistikdaten löschen."
                }
            ]
        },
        SYSTEM_PARA_WIRELESS: {
            TITLE: "2,4-/5GHz-WLAN",
            CONTENT: [
                {
                    type: "name",
                    title: "Ortungsintervall",
                    content: "Geben Sie einen Wert von 40 bis 1000 Millisekunden ein, um damit die Zeitdauer zwischen zwei Ortungspaketen zur WLAN-Synchronisierung festzulegen. Standardwert: 100 Millisekunden."
                }, {
                    type: "name",
                    title: "RTS-Grenzwert",
                    content: "Hier können Sie den RTS(Request to Send)-Grenzwert angeben. Ist ein Paket größer als dieser Wert, sendet der Router RTS-Frames zu einer bestimmten WLAN-Geräten, um den Versand eines Datenframes abzustimmen. Standardwert: 2346."
                }, {
                    type: "name",
                    title: "DTIM-Intervall",
                    content: "Dieser Wert bezeichnet die Intervalllänge zwischen zwei aufeinanderfolgenden Delivery Traffic Indication Messages (DTIMs). Ein DTIM-Feld ist ein Countdown, der die Clients des nächsten Fensters anweist, auf Broadcasts und Multicasts zu hören. Hat der Router Broadcasts oder Multicasts für verbundene Clients gepuffert, sendet er den nächsten DTIM. Sie können diese Dauer in Ortungsintervallen (1..15) angeben. Standard ist 1, d.h. das DTIM-Intervall ist genauso lang wie ein Ortungsintervall."
                }, {
                    type: "name",
                    title: "Gruppenschlüsselaktualisierungsintervall",
                    content: "Geben Sie die Dauer des Gruppenschlüsselaktualisierungsintervalls in Sekunden an. Dieser Wert muss 0 (=deaktiviert) oder mindestens 30 betragen."
                }, {
                    type: "name",
                    title: "WMM-Funktion",
                    content: "WMM garantiert, dass Nachrichten hoher Priorität bevorzugt übertragen werden. Es wird wärmstens empfohlen, diese Option aktiviert zu lassen."
                }, {
                    type: "name",
                    title: "Short-GI",
                    content: "Die Verwendung dieser Funktion wird empfohlen, da sie die Übertragungskapazitäten auf Kosten der Schutzintervallzeit vergrößert."
                }, {
                    type: "name",
                    title: "AP-Isolation",
                    content: "Standardmäßig ist diese Funktion deaktiviert. Möchten Sie verhindern, dass Ihre WLAN-Geräte miteinander kommunizieren können, während sie aber immer noch das Internet benutzen können, wählen Sie WLAN-Clients dürfen einander nicht sehen aus."
                }, {
                    type: "name",
                    title: "WDS-Bridging",
                    content: "Hiermit können Sie die WDS(Wireless Distribution System)-Bridge aktivieren. Damit kann der Router mittels Bridging mehrere WLANs miteinander verbinden. Ist die Option gewählt, müssen diese Felder ausgefüllt werden:",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "Geben Sie die SSID des WLANs, mit dem der Router sich als Client verbinden soll ein oder verwenden Sie die Suchfunktion, um in Ihrer Umgebung nach WLANs zu suchen."
                        }, {
                            type: "name",
                            title: "Suchen",
                            content: "Klicken Sie hier, um SSID, BSSID, Signalstärke, Kanal und Sicherheitsinformationen der WLANs in Ihrer Umgebung anzeigen zu lassen. Klicken Sie dann eines davon an, werden die Felder SSID, MAC-Adresse und Sicherheit automatisch ausgefüllt."
                        }, {
                            type: "name",
                            title: "zu bridgende MAC-Adresse",
                            content: "Geben Sie die MAC-Adresse (BSSID) des zu verbindenden Accesspoints, bestehend aus 12 Hexadezimalzeichen (0..9, a..f) im Format AA-AA-AA-AA-AA-AA ein. Haben Sie das zu verbindende WLAN angeklickt, wird dieses Feld automatisch ausgefüllt."
                        }, {
                            type: "name",
                            title: "Sicherheit",
                            content: "Der Sicherheitstyp des zu verbindenden WLANs: Keine, WPA-PSK/WPA2-PSK oder WEP. Haben Sie das zu verbindende WLAN angeklickt, wird dieses Feld automatisch ausgefüllt.",
                            children: [
                                {
                                    type: "name",
                                    title: "Passwort",
                                    content: "Das WLAN-Passwort im Fall, dass Sie WPA-PSK/WPA2-PSK oder WEP benutzen."
                                }, {
                                    type: "name",
                                    title: "Authentifizierungstyp",
                                    content: "Diese Option ist nur verfügbar, wenn der Sicherheitstyp WEP ist. Wählen Sie den im gewählten WLAN gültigen Authentifizierungstyp (Automatisch, Offen oder Shared-Key)."
                                }, {
                                    type: "name",
                                    title: "WEP-Schlüsselformat",
                                    content: "Diese Option ist nur verüfgbar, wenn Sie WEP verwenden. Wählen Sie zwischen ASCII und Hexadezimal."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Speichern, um Ihre Einstellungen zu übernehmen."
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wählen Sie WPS aktivieren an und klicken Sie Speichern, um WPS (WiFi Protected Setup) zu verwenden. Damit integrieren Sie WPS-fähige Geräte ganz einfach auf Tastendruck in Ihr WLAN."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAT",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Aktivieren Sie NAT, um NAT (Network Address Translation) zu aktivieren."
                }, {
                    type: "name",
                    title: "NAT-Boost",
                    content: "Aktivieren Sie NAT-Boost, um Ihrem Pouter den bestmöglichen NAT-Durchsatz zu erlauben."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "NAT-Boost wird deaktiviert, wenn entweder QoS or Trafficstatistiken ist aktiviert."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "DoS-Schutzebene",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Der DoS-Schutz schützt Ihren Router vor TCP-SYN-Flood-, UDP-Flood- und ICMP-Flood-Angriffen."
                }, {
                    type: "name",
                    title: "Grenzwert für ICMP-FLOOD-Pakete",
                    content: "Überschreitet die aktuelle Zahl der ICMP-FLOOD-Pakete diesen Wert, blockiert der Router alle weiteren sofort. Gültige Werte sind 5 bis 7200."
                }, {
                    type: "name",
                    title: "Grenzwert für UDP-FLOOD-Pakete",
                    content: "Überschreitet die aktuelle Zahl der UDP-FLOOD-Pakete diesen Wert, blockiert der Router alle weiteren sofort. Gültige Werte sind 5 bis 7200."
                }, {
                    type: "name",
                    title: "Grenzwert für TCP-FLOOD-Pakete",
                    content: "Überschreitet die aktuelle Zahl der TCP-SYN-FLOOD-Pakete diesen Wert, blockiert der Router alle weiteren sofort. Gültige Werte sind 5 bis 7200."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Speichern, um Ihre Einstellungen zu übernehmen."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "Duplex",
            CONTENT: [
                {
                    type: "name",
                    title: "Duplex",
                    content: "Wählen Sie aus der Drop-Down-Liste den Duplextyp aus."
                }, {
                    type: "paragraph",
                    content: "Klicken Sie Speichern, um Ihre Einstellungen zu übernehmen."
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Internetstatus",
                    content: "Zeigt an, ob Ihr Router mit dem Internet verbunden ist."
                }, {
                    type: "name",
                    title: "Verbindungstyp",
                    content: "Typ Ihrer Internetverbindung."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Die aktuell dem Router zugewiesene öffentliche IP-Adresse (Internet-IP-Adresse)."
                }, {
                    type: "name",
                    title: "Zweitverbindung/IP-Adresse",
                    content: "Typ und IP-Adresse Ihrer Zweitverbindung."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "Router",
            CONTENT: [
                {
                    type: "title",
                    title: "2,4-/5GHz-WLAN"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Name Ihres 2,4-/5GHz-WLANs."
                }, {
                    type: "name",
                    title: "Kanal",
                    content: "Kanal, den Ihr 2,4-/5GHz-WLAN aktuell verwendet."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "MAC-Adresse der 2,4-/5GHz-WLAN-Einheit Ihres Gerätes."
                }, {
                    type: "title",
                    title: "2,4GHz/5GHz-WLAN"
                }, {
                    type: "name",
                    title: "Status",
                    content: "Zeigt an, ob Ihr 2,4-/5GHz-Gast-WLAN aktiviert ist."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Name Ihres Gast-WLANs."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "Kabel-/WLAN-Geräte",
            CONTENT: [
                {
                    type: "name",
                    title: "Name",
                    content: "Name des mit dem Router verbundenen Geräts."
                }, {
                    type: "name",
                    title: "IP-Adresse",
                    content: "Die dem Gerät zugewiesene IP-Adresse."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die MAC-Adresse des Gerätes."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "Drucker",
            CONTENT: [
                {
                    type: "name",
                    title: "Name",
                    content: "Name des an den USB-Port angeschlossenen Druckers."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "USB-Datenträger",
            CONTENT: [
                {
                    type: "name",
                    title: "USB-Datenträger",
                    content: "Name des angeschlossenen Datenträgers."
                }, {
                    type: "name",
                    title: "Gesamt",
                    content: "Gesamtkapazität des USB-Datenträgers."
                }, {
                    type: "name",
                    title: "Verfügbar",
                    content: "Freier Speicherplatz auf dem USB-Datenträger."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Automatische Erkennung",
                    content: "Klicken Sie hier, um den Router Ihren Internetverbindungstyp automatisch erkennen zu lassen."
                }, {
                    type: "note",
                    title: "Hinweis",
                    content: "Sind Sie sich bezüglich des Internetverbindungstyps nicht sicher, verwenden Sie die Automatische Erkennung oder kontaktieren Sie Ihren Internetdiensteanbieter für Hilfe."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: Statische IP-Adresse"
                }, {
                    type: "name",
                    title: "IP-Adresse, Subnetzmaske, Standardgateway, Haupt-/Backup-DNS-Server",
                    content: "Geben Sie hier die von Ihrem Internetdiensteanbieter vorgegebenen Werte ein."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: Dynamische IP-Adresse"
                }, {
                    type: "name",
                    title: "MAC-Adresse NICHT klonen/MAC-Adresse des angeschlossenen Computers klonen",
                    content: "Hier können Sie die MAC-Adresse klonen, sofern Ihr Internetdiensteanbieter dies erfordert."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: PPPoE"
                }, {
                    type: "name",
                    title: "Benutzername/Passwort",
                    content: "Geben Sie hier die von Ihrem Internetdiensteanbieter vorgegebenen Zugangsdaten ein. Achten Sie hier auf Groß- und Kleinschreibung."
                }, {
                    type: "title",
                    title: "Internetverbindungstyp: L2TP/PPTP"
                }, {
                    type: "name",
                    title: "Benutzername/Passwort",
                    content: "Geben Sie hier die von Ihrem Internetdiensteanbieter vorgegebenen Zugangsdaten ein. Achten Sie hier auf Groß- und Kleinschreibung."
                }, {
                    type: "name",
                    title: "Zweitverbindung (Dynamische oder Statische IP-Adresse)",
                    children: [
                        {
                            type: "name",
                            title: "Dynamische IP-Adresse",
                            content: "Wählen Sie dies aus, wenn IP-Adresse und Subnetzmaske von Ihrem Internetdiensteanbieter automatisch vergeben werden."
                        }, {
                            type: "name",
                            title: "Statische IP-Adresse",
                            content: "Wählen Sie dies, wenn Sie IP-Adresse, Subnetzmaske, Standardgateway und DNS-Serveradressen von Ihrem Internetdiensteanbieter bekommen haben und geben Sie diese in die passenden Felder ein."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP-Adresse/Domänenname des VPN-Servers",
                    content: "Geben Sie die IP-Adresse oder den Hostnamen des VPN-Servers ein."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: "WLAN-Einstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "WLAN aktivieren",
                    content: "Aktivieren des 2,4-/5GHz-WLANs."
                }, {
                    type: "name",
                    title: "WLAN-Name (SSID)",
                    content: "Hier können Sie optional den WLAN-Namen (SSID) ändern. Dieser kann bis zu 32 Zeichen lang sein. Es wird zwischen Groß- und Kleinschreibung unterschieden."
                }, {
                    type: "name",
                    title: "SSID verbergen",
                    content: "Wählen Sie dies aus, um Ihr 2,4-/5GHz-WLAN zu verstecken."
                }, {
                    type: "name",
                    title: "Passwort",
                    content: "Geben Sie ein aus 8 bis 63 ASCII- oder 8 bis 64 Hexadezimal-Zeichen bestehendes Passwort ein. Es wird zwischen Groß- und Kleinschreibung unterschieden."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "Geräteeinstellungen",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Auf der Seite Geräteeinstellungen sehen Sie Informationen zu am USB-Port angeschlossenen Geräten."
                }, {
                    type: "name",
                    title: "Suchen",
                    content: "Normalerweise findet der Router neu angeschlossene USB-Geräte automatisch. Mit dieser Schaltfläche können Sie angeschlossene USB-Geräte manuell erkennen lassen."
                }, {
                    type: "name",
                    title: "Name",
                    content: "Zeigt den Namen der Partition."
                }, {
                    type: "name",
                    title: "Kapazität",
                    content: "Gesamtkapazität des USB-Datenträgers"
                }, {
                    type: "name",
                    title: "Freier Speicherplatz",
                    content: "Aktuell verfügbarer Speicherplatz auf dem USB-Datenträger."
                }, {
                    type: "name",
                    title: "Sicher entfernen",
                    content: "Klicken Sie hier, bevor Sie das USB-Gerät physisch vom Router entfernen.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Hinweis: Die Schaltfläche Sicher entfernen erscheint nur, wenn ein USB-Datenträger an den Router angeschlossen ist. Die Operation ist nicht zulässig, solange der USB-Datenträger sich noch in Verwendung befindet."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Aktiv",
                    content: "Diese Option erscheint nur, wenn ein USB-Datenträger an den Router angeschlossen ist. Aktiviert die Freigabe des USB-Geräts."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "Freigabeeinstellungen",
            CONTENT: [
                {
                    type: "name",
                    title: "Netz-/Mediaserver-Name",
                    content: "Der Name, unter dem der angeschlossene USB-Datenträger erreichbar ist."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "Ordnerfreigabe",
            CONTENT: [
                {
                    type: "name",
                    title: "Komplett freigeben",
                    content: "Ermöglicht die Freigabe des ganzen USB-Datenträgers. Möchten Sie nur einzelne Ordner freigeben, deaktivieren Sie diese Option."
                }, {
                    type: "name",
                    title: "Authentifizierung aktivieren",
                    content: "Ist dies aktiviert, müssen Benutzer einen Namen und ein Passwort eingeben, um Zugriff auf die freigegebenen Ordner zu erhalten (empfohlen)."
                }, {
                    type: "name",
                    title: "Ordnername",
                    content: "Name des freigegebenen Ordners."
                }, {
                    type: "name",
                    title: "Ordnerpfad",
                    content: "Der Pfad zu dem freigegebenen Ordner."
                }, {
                    type: "name",
                    title: "Medienfreigabe",
                    content: "Erlaubt dem Mediaserver die Verwendung dieses Ordners."
                }, {
                    type: "name",
                    title: "Datenträgername",
                    content: "Name des freigegebenen Datenträgers."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Zeigt den Status des freigegebenen Ordners an. Grün (Ein) bedeutet aktiviert and Grau (Aus) bedeutet deaktiviert. Der Status kann durch einen Klick auf die Glühbirne umgeschaltet werden."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Bietet Optionen zum Bearbeiten und zum Löschen einer Freigabe."
                }, {
                    type: "name",
                    title: "Hinzufügen",
                    content: "Anlegen eines neuen Eintrags."
                }, {
                    type: "name",
                    title: "Löschen",
                    content: "Entfernen einer Freigabe."
                }, {
                    type: "name",
                    title: "Durchsuchen",
                    content: "Auswahl eines freizugebenden Ordners."
                }, {
                    type: "name",
                    title: "Zugriff aus dem Gastnetz erlauben",
                    content: "Bestimmt, ob die Teilnehmer Ihres Gastnetzes Zugriff auf die Freigabe bekommen."
                }, {
                    type: "name",
                    title: "Authentifizierung aktivieren",
                    content: "Ist dies aktiviert, müssen Benutzer einen Namen und ein Passwort eingeben, um Zugriff auf die freigegebenen Ordner zu erhalten (empfohlen)."
                }, {
                    type: "name",
                    title: "Schreibzugriff erlauben",
                    content: "Erlaubt dem Benutzer das Verändern von Datenträgerinhalten."
                }, {
                    type: "name",
                    title: "Medienfreigabe",
                    content: "Erlaubt dem Mediaserver die Verwendung dieses Ordners."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "Printserver",
            CONTENT: [
                {
                    type: "name",
                    title: "Printserver aktivieren",
                    content: "Aktivieren des Printservers."
                }, {
                    type: "name",
                    title: "Druckername",
                    content: "Name des angeschlossenen Druckers."
                }, {
                    type: "step",
                    title: "So richten Sie auf Ihrem Router einen Printserver ein:",
                    content: ["1.	Verbinden Sie einen unterstützten USB-Drucker mit dem USB-Port des Routers.", "2.	Installieren Sie auf Ihrem Computer den Druckertreiber. Details hierzu finden Sie im Druckerhandbuch.", "3. Installieren Sie TP-LINKs USB-Drucker-Controller-Utility entweder von CD (nur für Windows) oder nach Download von TP-Links Webpräsenz (sowohl für Windows als auch für MacOS X)."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "Kindersicherung",
            CONTENT: [
                {
                    type: "name",
                    title: "Status",
                    content: "Aktivieren der Kindersicherung. Standardmäßig ist diese Funktion deaktiviert."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "Der Kindersicherung unterliegende Geräte",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Eine Liste der der Kindersicherung unterliegenden Geräte."
                }, {
                    type: "name",
                    title: "Gerätename",
                    content: "Die Namen aller verbundenen und von der Kindersicherung betroffenen Clientgeräte."
                }, {
                    type: "name",
                    title: "MAC-Adresse",
                    content: "Die MAC-Adressen aller verbundenen und von der Kindersicherung betroffenen Clientgeräte."
                }, {
                    type: "name",
                    title: "Internetzugriffszeit",
                    content: "Zeitrahmen, für den die Kindersicherung gilt."
                }, {
                    type: "name",
                    title: "Beschreibung",
                    content: "Kurze Beschreibung des Gerätes."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Aktueller Status der Kindersicherung für dieses Gerät (aktiviert oder deaktiviert)."
                }, {
                    type: "name",
                    title: "Bearbeiten",
                    content: "Bearbeiten oder Löschen eines Geräteeintrags."
                }, {
                    type: "step",
                    title: "So sperren Sie den Internetzugang für ein neues Gerät:",
                    content: [
                        "1. 	Klicken Sie Hinzufügen.",
                        "2. Klicken Sie Existierende Geräte und wählen Sie aus der Geräteliste ein aktuell verbundenes Gerät. Oder Sie geben Namen und MAC-Adresse des Geräts von Hand ein, z.B. falls es aktuell nicht verbunden ist.",
                        "3. 	Klicken Sie Internetzugriffszeitfenster, um die Zeit des Internetzugriffs einzuschränken.",
                        "4. Vergeben Sie eine kurze Beschreibung (optional).",
                        "5. Wählen Sie Aktivieren.",
                        "6. Klicken Sie OK, um den neuen Eintrag zu speichern."
                    ]
                }, {
                    type: "paragraph",
                    content: "Um einen Kindersicherungseintrag zu bearbeiten oder zu löschen, klicken Sie Bearbeiten bzw. Löschen."
                }, {
                    type: "paragraph",
                    content: "Um mehrere Einträge zu löschen, wählen Sie diese aus und klicken Sie über der Tabelle auf Löschen."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "Gastnetz",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Errichten Sie ein Gastnetz, können Sie Ihre Gäste von Ihrem lokalen Netz fernhalten, indem diese einen anderen WLAN-Namen und ein anderes Passwort verwenden."
                }, {
                    type: "name",
                    title: "Gäste dürfen einander sehen",
                    content: "Aktivieren Sie dies, um alle Gastnetzteilnehmer einander sichtbar zu machen."
                }, {
                    type: "name",
                    title: "Gäste dürfen nicht auf die Routeroberfläche zugreifen.",
                    content: "Wählen Sie diese Option, um zu verhindern, dass Ihre Gäste auf die Weboberfläche Ihres Routers zugreifen."
                }, {
                    type: "name",
                    title: "Gastnetz aktivieren",
                    content: "Wählen Sie dies aus, um Ihr 2,4GHz-/5GHz-Gastnetz zu aktivieren."
                }, {
                    type: "name",
                    title: "WLAN-Name (SSID)",
                    content: "Gast-WLAN-Name, kann frei gewählt werden (1 bis 32 Zeichen)."
                }, {
                    type: "name",
                    title: "SSID verbergen",
                    content: "Hiermit können Sie Ihr Gast-WLAN unsichtbar machen."
                }, {
                    type: "name",
                    title: "Passwort",
                    content: "Vergeben Sie ein WLAN-Passwort aus 8 bis 63 ASCII-Zeichen oder 8 bis 64 Hexadezimalzeichen, um Ihr Gastnetz gegen unbefugte Benutzung zu sichern."
                }
            ]
        },
        "": ""
    };
})(jQuery);
